% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimulateGroupGaussian.R
\name{simulate_group_gaussian}
\alias{simulate_group_gaussian}
\title{Simulate Group Multivariate Gaussian Data}
\usage{
simulate_group_gaussian(param_list, group_col_name)
}
\arguments{
\item{param_list}{A list of named sublists, where each sublist contains the
parameters for a group (sample size, mean, standard deviation, and
correlation matrix). The dimension of the parameters for each group must be
the same.}

\item{group_col_name}{The column name of the grouping/label column to be
created in the final data frame. The values are taken from the names of the
sublists of \code{param_list}. Defaults to "group". See the example below.}
}
\value{
A data frame with the simulated data for all groups, including the
grouping column.
}
\description{
This function generates data for each group from a Multivariate
Gaussian (Normal) Distribution by invoking this distribution's random
generator once per group. It binds the generated data together into a single
data frame.
}
\examples{
# Example using MASS::mvrnorm for normal distribution
param_list <- list(
  Male = list(
    sampSize = 50,
    mean_vec = c(1, 2),
    sampSD = c(2, 1),
    sampCorr_mat = matrix(c(1, 0.5, 0.5, 1), 2, 2)
  ),
  Female = list(
    sampSize = 100,
    mean_vec = c(2, 3),
    sampSD = c(1, 2),
    sampCorr_mat = matrix(c(1, 0.3, 0.3, 1), 2, 2)
  )
)
simulate_group_gaussian(param_list, "Sex")

}
