% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_test_update_fn.R
\name{create_test_update_fns}
\alias{create_test_update_fns}
\title{Create Test Update Functions}
\usage{
create_test_update_fns(
  fn_names,
  id_arg = "inputId",
  value_args = c("value", "selected"),
  range_value_args = c("start", "end"),
  .package = "shiny"
)
}
\arguments{
\item{fn_names}{A character vector (string) of function names to create wrappers for}

\item{id_arg}{A character string of the argument in `fn_names` that relates to the HTML ID argument.
Default is \code{"inputId"}}

\item{value_args}{A character vector of the arguments in `fn_names` that relate to the input
value arguments.
Defaults are `"value"` and `"selected`.}

\item{range_value_args}{A character vector of the arguments in `fn_names` that relate to the input
value arguments when multiple arguments can be used to update the input.
Defaults are `"start"` and `"end"`.}

\item{.package}{Character string of the package that `fn_names` exist in.
Default is `"shiny"`}
}
\value{
A named list of function expressions, one for each function supplied in `fn_names`.
}
\description{
Given a set of functions from an R package, create a set of mocked functions that
can be used as bindings to test UI updates within \code{testServer}.
}
\examples{
create_test_update_fns(
  c("updateSelectInput", "updateTextInput"),
  .package = "shiny"
)

}
