% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count_strata.R
\name{count_strata}
\alias{count_strata}
\title{Count observations by stratum}
\usage{
count_strata(
  data,
  strata_varnames,
  biomarker_names_var = get_biomarker_names_var(data)
)
}
\arguments{
\item{data}{a \code{"pop_data"} object (e.g., from \code{\link[=as_pop_data]{as_pop_data()}})}

\item{strata_varnames}{a \link{vector} of \link{character} strings matching
colnames to stratify on from \code{data}}

\item{biomarker_names_var}{a \link{character} string indicating the column
of \code{data} indicating which biomarker is being measured}
}
\value{
a \link[tibble:tbl_df-class]{tibble::tbl_df} counting observations by stratum
}
\description{
Count observations by stratum
}
\examples{
sees_pop_data_pk_100 |> count_strata(strata_varnames = "catchment")
}
\keyword{internal}
