% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partialDependence.R
\name{partialDependence_data}
\alias{partialDependence_data}
\title{Create dataset to compute partial dependence}
\usage{
partialDependence_data(
  data,
  reference.var,
  support = 20,
  points = NULL,
  mc = NULL,
  keep_id = FALSE
)
}
\arguments{
\item{data}{The \code{data.frame} that was used to train the
model.}

\item{reference.var}{Character vector, referring to the (independent)
reference variable or variables for which partial dependence is calculated.
Providing two (or more) variables allows for probing interactions, but note
that this is computationally expensive.}

\item{support}{Integer. Number of grid points for interpolating the
\code{reference.var}. Alternatively, use \code{points} for one or more
variables named in \code{reference.var}.}

\item{points}{Named list, with elements corresponding to \code{reference.var}
. Use this argument to provide specific points for which to obtain marginal
dependence values; for example, the mean and +/- 1SD of \code{reference.var}.}

\item{mc}{Integer. If \code{mc} is not \code{NULL}, the function will sample
\code{mc} number of rows from \code{data} with replacement, to estimate}

\item{keep_id}{Boolean. Default is false. Should output contain a row id column?
marginal dependency using Monte Carlo integration. This is less
computationally expensive.}
}
\description{
Create a dataset with fixed values for \code{reference.var} for all other
values of \code{data}, or using \code{mc} random samples from \code{data}
(Monte Carlo integration).
}
\author{
Caspar J. Van Lissa
}
