% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scorecard.R
\name{scorecard}
\alias{scorecard}
\title{Creating a Scorecard}
\usage{
scorecard(bins, model, points0 = 600, odds0 = 1/19, pdo = 50,
  basepoints_eq0 = FALSE, digits = 0)
}
\arguments{
\item{bins}{Binning information generated from \code{woebin} function.}

\item{model}{A glm model object.}

\item{points0}{Target points, default 600.}

\item{odds0}{Target odds, default 1/19. Odds = p/(1-p).}

\item{pdo}{Points to Double the Odds, default 50.}

\item{basepoints_eq0}{Logical, Defaults to FALSE. If it is TRUE, the basepoints will equally distribute to each variable.}

\item{digits}{The number of digits after the decimal point for points calculation. Default 0.}
}
\value{
A list of scorecard data frames
}
\description{
\code{scorecard} creates a scorecard based on the results from \code{woebin} and \code{glm}.
}
\examples{
\donttest{
# load germancredit data
data("germancredit")
# filter variable via missing rate, iv, identical value rate
dtvf = var_filter(germancredit, "creditability")
# split into train and test
dtlst = split_df(dtvf, y = 'creditability')
# binning
bins = woebin(dtlst$train, "creditability")

# to woe
dtlst_woe = lapply(dtlst, function(d) woebin_ply(d, bins))
# lr
m = glm(creditability ~ ., family = binomial(), data = dtlst_woe$train)
# scorecard
card = scorecard(bins, m)
prob = predict(m, dtlst_woe$train, type='response')
# problst = lapply(dtlst_woe, function(x) predict(m, x, type='response'))

}
}
\seealso{
\code{\link{scorecard2}} \code{\link{scorecard_ply}}
}
