% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_alpha_table.R
\name{make_alpha_table}
\alias{make_alpha_table}
\title{Wrap a pre computed psych::alpha object into a single row table}
\usage{
make_alpha_table(alpha_res, scale_name = "Scale")
}
\arguments{
\item{alpha_res}{A psych::alpha object (already computed)}

\item{scale_name}{Name of the scale (default: "Scale")}
}
\value{
A data frame with columns: Scale, 95\% CI lower, Alpha, 95\% CI upper
}
\description{
Wrap a pre computed psych::alpha object into a single row table
}
\examples{
# Create a minimal "psych::alpha" like object manually
alpha_obj <- list(
  total = list(
    raw_alpha = 0.85,
    lower = 0.78,
    upper = 0.92
  )
)

# Generate the formatted alpha table
make_alpha_table(alpha_obj, scale_name = "PHQ-9")
}
