% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Color_Palettes.R
\name{PalettePlot}
\alias{PalettePlot}
\title{Plot color palette in viewer}
\usage{
PalettePlot(pal = NULL, label_color_num = NULL)
}
\arguments{
\item{pal}{a vector of colors (either named colors of hex codes).}

\item{label_color_num}{logical, whether or not to numerically label the colors in output plot.
Default is TRUE is number of colors in \code{pal} is less than 75 and FALSE is greater than 75.}
}
\value{
Plot of all colors in supplied palette/vector
}
\description{
Plots given color vector/palette in viewer to evaluate palette before plotting on data.
}
\examples{
pal <- DiscretePalette_scCustomize(num_colors = 36, palette = "varibow")
PalettePlot(pal = pal)

}
\references{
Adapted from colorway package \code{build_palette} internals (License: GPL-3).
\url{https://github.com/hypercompetent/colorway}.
}
\concept{palettes}
