% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/snowprofile.R
\name{snowprofile}
\alias{snowprofile}
\title{High-level constructor for a snowprofile object}
\usage{
snowprofile(
  station = as.character(NA),
  station_id = as.character(NA),
  datetime = as.POSIXct(NA),
  latlon = as.double(c(NA, NA)),
  elev = as.double(NA),
  angle = as.double(NA),
  aspect = as.double(NA),
  hs = as.double(NA),
  maxObservedDepth = as.double(NA),
  type = "manual",
  band = as.character(NA),
  zone = as.character(NA),
  comment = as.character(NA),
  hn24 = as.double(NA),
  hn72 = as.double(NA),
  ski_pen = as.double(NA),
  layers = snowprofileLayers(dropNAs = FALSE, validate = FALSE),
  tests = snowprofileTests(dropNAs = FALSE),
  instabilitySigns = snowprofileInstabilitySigns(dropNAs = FALSE),
  validate = TRUE,
  dropNAs = TRUE
)
}
\arguments{
\item{station}{character string}

\item{station_id}{character string}

\item{datetime}{date and time as class POSIXct in most meaningful timezone (timezone can be converted very easily:
e.g. \code{print(profile$datetime, tz = 'EST')}.}

\item{latlon}{2-element vector latitude (first), longitude (second)}

\item{elev}{profile elevation (m)}

\item{angle}{slope angle (degree)}

\item{aspect}{slope aspect (degree)}

\item{hs}{total snow height (cm); if not provided, the field will be derived from the profile layers.}

\item{maxObservedDepth}{equivalent to \code{hs} for full profiles that go down to the ground. for test profiles that only
observe the upper part of the snowpack this value refers to the maximum depth of the profile observation.}

\item{type}{character string, must be either 'manual', 'modeled', 'vstation', 'aggregate', or 'whiteboard'}

\item{band}{character string describing elevation band as ALP, TL, BTL (alpine, treeline, below treeline)}

\item{zone}{character string describing the zone or region of the profile location (e.g., BURNABY_MTN)}

\item{comment}{character string with any text comments}

\item{hn24}{height of new snow within 24 h}

\item{hn72}{height of new snow within 72 h}

\item{ski_pen}{skier penetration depth (m)}

\item{layers}{\link{snowprofileLayers} object}

\item{tests}{\link{snowprofileTests} object}

\item{instabilitySigns}{\link{snowprofileInstabilitySigns} object}

\item{validate}{Validate the object with \link{validate_snowprofile}?}

\item{dropNAs}{Do you want to drop non-mandatory \code{snowprofile} and \code{snowprofileLayers} fields that are \code{NA} only?}
}
\value{
snowprofile object
}
\description{
Conveniently create a snowprofile object. Calls low-level constructor (only available internally: \link{new_snowprofile}), asserts correctness
through a snowprofile validator function (\link{validate_snowprofile}) and yields meaningful error messages. Use low-level constructor if you generate many (!) profiles.
}
\examples{

## Empty snowprofile:
snowprofile()

## Test profile:
testProfile <- snowprofile(station = 'SARPstation', station_id = 'SARP007',
                           datetime = as.POSIXct('2019/04/01 10:00:00', tz = 'Etc/GMT+7'),
                           latlon = c(49.277223, -122.915084), aspect = 180,
                           layers = snowprofileLayers(height = c(10, 25, 50),
                                                      hardness = c(3, 2, 1),
                                                      gtype = c('FC', NA, 'PP')))
summary(testProfile)
plot(testProfile)

}
\seealso{
\link{summary.snowprofile}, \link{plot.snowprofile}, \link{snowprofileLayers}, \link{snowprofileTests}, \link{snowprofileInstabilitySigns}, \link{SPpairs}
}
\author{
shorton, fherla
}
