% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SaemixData-methods_covariates.R
\name{transformCatCov}
\alias{transformCatCov}
\title{Transform categorical covariates}
\usage{
transformCatCov(
  object,
  covariate,
  oldCat = NULL,
  newCat = NULL,
  newCatName = NULL,
  verbose = FALSE
)
}
\arguments{
\item{object}{saemixData object}

\item{covariate}{name of the covariate}

\item{oldCat}{a vector giving the initial categories of the covariate (if NULL, defaults to the unique values of the covariate)}

\item{newCat}{a vector of consecutive integers 1:N, giving the N categories to which the initial values of the covariate should be mapped, with 1 denoting the reference class. If the resulting covariate is binary, it will be stored as 0/1. If it has more than 2 categories, N dummy covariates 0/1 will be created. If not given, the initial categories of the covariate will be mapped to 1:N and transformed into N dummy covariates 0/1.}

\item{newCatName}{the name of the new group. If NULL (default), binary covariates will be renamed as covariate.mod, while for categorical covariates, the new covariates will be named covariate.ref, covariate.G2, covariate.G3, etc...}

\item{verbose}{a boolean, prints messages during the execution of the function if TRUE. Defaults to FALSE.}
}
\value{
an object of class \code{"\linkS4class{SaemixData}"}
}
\description{
This function is used to automatically map categorical covariates to dummy binary covariates. It can also be used to regroup categorical covariates before the analysis, for example mapping a covariate initially in 5 categories to only 3 categories.
For binary covariates, the covariate will simply be transformed to 0/1 with the reference category being 0.
}
\details{
For a binary covariate, a dummy covariate with values 0 for the reference class and 1 for the other category will be created and will replace the original dataset in the covariate
For covariates with 3 categories or more (categorical covariates), dummy variables with values 0/1 will be created for the reference class and for each contrast with the reference class (category 2 versus reference, category 3 versus reference, etc...)
If these covariates have units, the dummy covariates will have the same unit (which may not be appropriate and can then be changed by the user)
}
\examples{
data(cow.saemix)
saemix.data<-saemixData(name.data=cow.saemix,header=TRUE,name.group=c("cow"),
                   name.predictors=c("time"),name.response=c("weight"),
                   name.covariates=c("birthyear","twin","birthrank"),
                   units=list(x="days",y="kg",covariates=c("yr","-","-")))
unique(saemix.data@data$birthrank) # 5 categories, 3 4 5 6 7
# create 3 dummy variables regrouping 3 (reference), 4 and 5, and 6 and 7
cowt <- transformCatCov(saemix.data, covariate=birthrank, newCat=c(1,2,2,3,3), verbose=TRUE) 
head(saemix.data@data) # the original covariate is birthrank
head(cowt@data) 
# the new covariates are birthrank.ref (initially 3), birthrank.G2 (regrouping 4 and 5) and 
# birthrank.G3 (6 and 7)
# only birthrank.G2 and birthrank.G3 are included in the name.covariates slot of the object cowt
cowt <- transformCatCov(cowt, covariate=birthrank, newCat=c(1,2,2,3,3), 
   newCatName=c("ref","preg4-5","6-7"), verbose=TRUE)
head(cowt@data) 
# new names can be assigned to the dichotomised covariates through the newCatName argument
# the new covariates are now "ref", preg4-5" (regrouping 4 and 5) and "6-7" (6 and 7)

# Changing the reference for a binary variable
cowt<-transformCatCov(cowt, covariate=twin, newCat=c(2,1), newCatName="Singleton", verbose=TRUE)

}
\keyword{data}
