% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotOneFactor.r
\name{plotOneFactor}
\alias{plotOneFactor}
\title{Bar plot of gene expression for single-factor experiments}
\usage{
plotOneFactor(
  data,
  x_col,
  y_col,
  Lower.se_col,
  Upper.se_col,
  letters_col = NULL,
  letters_d = 0.2,
  col_width = 0.8,
  err_width = 0.15,
  fill_colors = "grey40",
  alpha = 1,
  base_size = 12,
  legend_position = "none",
  ...
)
}
\arguments{
\item{data}{Data frame}

\item{x_col}{Numeric. Column index for x-axis}

\item{y_col}{Numeric. Column index for bar height}

\item{Lower.se_col}{Numeric. Column index for lower SE}

\item{Upper.se_col}{Numeric. Column index for upper SE}

\item{letters_col}{Optional column index for grouping letters}

\item{letters_d}{Numeric. Vertical offset for letters (default 0.2)}

\item{col_width}{Numeric. Width of bars (default 0.8)}

\item{err_width}{Numeric. Width of error bars (default 0.15)}

\item{fill_colors}{Optional vector of fill colors}

\item{alpha}{Numeric. Transparency of bars (default 1)}

\item{base_size}{Numeric. Base font size for theme (default 12)}

\item{legend_position}{Character. Legend position (default "right")}

\item{...}{Additional valid ggplot2 layer arguments}
}
\value{
ggplot2 plot object
}
\description{
Creates a bar plot of relative gene expression (fold change) values
from a single-factor experiment, including standard error or
confidence interval error bars and statistical significance.
}
\details{
The \code{plotOneFactor} function generates a bar plot of fold change
values for target genes using the output expression tables produced by
functions such as \code{ANOVA_DDCt()} or \code{ANOVA_DCt()}.
Error bars can represent either standard error (SE) or 95\% confidence
intervals, and optional grouping letters from post hoc statistical
comparisons can be displayed above the bars.
}
\examples{

a <- ANOVA_DCt(
data_1factor,
numberOfrefGenes = 1,
block = NULL
)
data <- a$Results

plotOneFactor(
  data,
  x_col = 1,
  y_col = 2,
  Lower.se_col = 7,
  Upper.se_col = 8,
  letters_col = 11,
  letters_d = 0.1,
  col_width = 0.7,
  err_width = 0.15,
  fill_colors = "skyblue",
  alpha = 1,
  base_size = 16
)



}
\author{
Ghader Mirzaghaderi
}
