% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-bag.R
\name{is_rocrate_bag}
\alias{is_rocrate_bag}
\title{Check if path points to a valid RO-Crate bag}
\usage{
is_rocrate_bag(path, algo = "sha512", bagit_version = "1.0")
}
\arguments{
\item{path}{String with full path to a compressed file contain an RO-Crate
bag, see \link[rocrateR]{bag_rocrate} for details. Alternatively, a path
to a directory containing an RO-Crate bag.}

\item{algo}{String with algorithm used to generate the RO-Crate bag
(default: \code{"sha512"}). See \link[digest]{digest} for more details.}

\item{bagit_version}{String with version of BagIt used to generate the
RO-Crate bag (default: \code{"1.0"}).
See \doi{10.17487/RFC8493} for more details.}
}
\value{
Returns invisibly the RO-Crate pointed by \code{path}.
}
\description{
Check if path points to a valid RO-Crate bag
}
\seealso{
Other bag_rocrate: 
\code{\link{bag_rocrate}()},
\code{\link{unbag_rocrate}()}
}
\concept{bag_rocrate}
