% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_statis_phase1_chart.R
\name{plot_statis_phase1_chart}
\alias{plot_statis_phase1_chart}
\title{Plot Control Chart - Robust STATIS Dual (Phase 1)}
\usage{
plot_statis_phase1_chart(
  batch_statistics,
  num_vars,
  title = "Robust STATIS Dual Control Chart - Phase 1"
)
}
\arguments{
\item{batch_statistics}{A data frame with columns \code{Batch} and \code{T2_Stat},
typically from \code{phase1_result$batch_statistics}.}

\item{num_vars}{Integer. Number of variables used in the multivariate analysis (to compute the Chi² threshold).}

\item{title}{Optional string. Plot title.}
}
\value{
A ggplot2 object.
}
\description{
Plots the Hotelling T² statistic per batch using the robust center and compromise
matrix estimated in \code{robust_statis_phase1()}. The control limit is based on a
Chi-squared distribution with degrees of freedom equal to the number of variables.
}
\examples{
sim_batches <- simulate_pharma_batches()

# Phase 1 analysis: select under control batches from Phase 1
phase1_result <- robust_statis_phase1(
  data = subset(sim_batches, Phase == "Phase 1" & Status == "Under Control"),
  variables = c("Concentration", "Humidity", "Dissolution", "Density")
)

# Plot the Phase 1 robust control chart
plot_statis_phase1_chart(
  batch_statistics = phase1_result$batch_statistics,
  num_vars = 4
)
}
