% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/juliabugs.R
\name{juliaBUGS}
\alias{juliaBUGS}
\title{Run a Julia HMC Sampler for a BUGS-like Probabilistic Model}
\usage{
juliaBUGS(
  data,
  model_def,
  params_to_save,
  initializations = NULL,
  name = "sampler_juliaBUGS",
  n_iter = 2000,
  n_warmup = floor(n_iter/2),
  n_discard = n_warmup,
  n_thin = 1,
  n_chain = 1,
  use_parallel = TRUE,
  posterior_type = "array",
  force_setup_juliaBUGS = FALSE,
  control = NULL,
  progress = TRUE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{data}{A named list of numeric values (integer or double). All elements must be named.}

\item{model_def}{A character string with the model definition, either in Julia-compatible format or BUGS syntax.}

\item{params_to_save}{Character vector with the names of model parameters to extract from the sampler output.}

\item{initializations}{A named list of parameter names for which you may wish to set corresponding initial values for the sampler.
The default is \code{NULL}, which means no default initial values are used.}

\item{name}{Character. Name for the sampler object created in Julia (must be a valid Julia variable name).}

\item{n_iter}{Integer. Total number of MCMC iterations. Default is 2000.}

\item{n_warmup}{Integer. Number of iterations used warm-up or tuning (e.g., adaption steps in NUTS). Default is \code{floor(n_iter / 2)}.}

\item{n_discard}{Integer. Number of initial samples to be completely discarded. Default is \code{n_warmup}, i.e: discard all the iterations used as adaptation steps.}

\item{n_thin}{Integer. Thinning interval. Default is 1 (no thinning).}

\item{n_chain}{Integer. Number of MCMC chains. Default is 1.}

\item{use_parallel}{Logical. Whether to use \code{AbstractMCMC.MCMCThreads()} for parallel sampling. Default is \code{TRUE}.}

\item{posterior_type}{Character. Format of the posterior samples. One of \code{"array"}, \code{"rvar"}, \code{"mcmc"}, or \code{"draws"}. Default is \code{"array"}.}

\item{force_setup_juliaBUGS}{Logical. If \code{TRUE}, forces reinitialization of the Julia environment via \code{setup_juliaBUGS()}. Default is \code{FALSE}.}

\item{control}{Optional list of control parameters. Supported entries:
\describe{
\item{\code{data_convert_int}}{Logical. If \code{TRUE}, coerces numeric values to integers when possible. Default is \code{TRUE}.}
\item{\code{convert_var_name}}{Logical. If \code{TRUE}, automatically renames variables in the Bayesian Updating for Gibbs Sampling (BUGS) model. Default is \code{FALSE}.}
\item{\code{julia_model}}{Logical. If \code{TRUE}, assumes the model is already in Julia format used by the models under the \code{Turing.jl} appraoch, not a Bayesian Updating for Gibbs Sampling (BUGS) model. Default is \code{FALSE}.}
}}

\item{progress}{Logical. If \code{TRUE}, a progress bar for the sampler is displayed;
if \code{FALSE}, no progress bar is shown. The default is \code{TRUE}. However, when the function
is run interactively inside an RStudio session, \code{progress} is automatically
overridden to \code{FALSE}, which suppresses the progress output from
\code{AbstractMCMC.sample}. For a complete progress bar display with \code{rjuliabugs},
as the one showed when running Julia code,we recommend running the code from
a terminal outside of RStudio.}

\item{verbose}{Logical. If \code{FALSE} will ommit any message from the function to indicate
the sampler/setup progress}

\item{...}{Additional arguments passed to \code{setup_juliaBUGS()}.}
}
\value{
An object of class \code{"rjuliabugs"} (a named list) with the following elements:
\describe{
\item{params}{Posterior samples, in the format specified by \code{posterior_type}
("array", "rvar", "mcmc", or "draws").}
\item{name}{A character string giving the name of the Julia sampler object.}
\item{sampler}{The sampler object returned by \code{AbstractMCMC.sample} in Julia.}
\item{n_threads}{An integer giving the number of Julia threads detected.}
\item{mcmc}{A list of MCMC configuration parameters used in the run.}
\item{control}{The list of control options passed to and used by the sampler.}
}
}
\description{
Executes a Hamiltonian Monte Carlo (HMC) sampler in Julia from R, using a model
specified in Julia or in BUGS syntax. It compiles the model, converts data,
sets sampler parameters, and returns posterior samples in various formats. The setup
for the HMC sampler uses Not-U-Turn Sampler (NUTS) with the target acceptance probability
\eqn{\delta}=0.8) for step size adaptation.
}
\details{
This function relies on Julia packages \code{LogDensityProblems}, \code{AdvancedHMC}, and \code{AbstractMCMC}.
Gradients are computed via \code{ReverseDiff}. The model is compiled before sampling.

The \code{posterior_type} argument determines the return format:
\itemize{
\item \code{"array"}: 3D numeric array (iterations × chains × parameters).
\item \code{"rvar"}: \code{posterior::rvar} object.
\item \code{"mcmc"}: \code{coda::mcmc} (single chain) or \code{mcmc.list} (multiple chains).
\item \code{"draws"}: \code{posterior::draws_array}.
}
}
\note{
You must call \code{setup_juliaBUGS()} at least once before using this function.
If parallel sampling is requested but only one Julia thread is available,
a warning is issued and sampling will run serially.
}
\examples{
\dontrun{
model_def <- "model = @model ... end"
data <- list(N = 10, x = rnorm(10))
result <- juliaBUGS(
  data = data,
  model_def = model_def,
  params_to_save = c("mu"),
  name = "my_sampler"
)
}

}
