% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributions.R
\name{density_t}
\alias{density_t}
\alias{cdf_t}
\alias{studentdistribution}
\alias{random_t}
\title{The Student Distribution}
\usage{
density_t(df, x)

cdf_t(df, x)

random_t(df, n)
}
\arguments{
\item{df}{degrees of freedom.}

\item{x}{vector of quantiles.}

\item{n}{number of observations.}
}
\value{
The functions density_XXX and cdf_t return numeric vectors of same length as \code{x}.
The functions random_XXX return random number (numeric vectors) of length \code{n}.
}
\description{
Probability Density Function (PDF), Cumulative Density Function (CDF) and generation of random variables following a Student distribution.
}
\examples{
\dontshow{if (current_java_version >= minimal_java_version) withAutoprint(\{ # examplesIf}
# Probability density function of T with 2 degrees of freedom.
z <- density_t(df = 2, .01 * seq(-100, 100, 1))
# Generating a random vector with each component drawn from a T(2) distribution
z <- random_t(2, 100)
# Computing the probabilty that the random variable X following a T distribution
# with df degrees of freedom is lower than x
z <- cdf_t(df = 12, x = 1.2)
z
z <- cdf_t(df = 12, x = c(0:10)) # array of values
z
\dontshow{\}) # examplesIf}
}
