% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spec_regarima.R
\name{set_basic}
\alias{set_basic}
\title{Set estimation sub-span and quality check specification}
\usage{
set_basic(
  x,
  type = c(NA, "All", "From", "To", "Between", "Last", "First", "Excluding"),
  d0 = NULL,
  d1 = NULL,
  n0 = 0,
  n1 = 0,
  preliminary.check = NA,
  preprocessing = NA
)
}
\arguments{
\item{x}{the specification to customize, must be a "SPEC" class object (see
details).}

\item{type, d0, d1, n0, n1}{parameters to specify the sub-span .

\code{d0} and \code{d1} characters in the format "YYYY-MM-DD" to specify
first/last date of the span when \code{type} equals to \code{"From"},
\code{"To"} or \code{"Between"}.
Date corresponding to \code{d0} will be included in the sub-span
Date corresponding to \code{d1} will be excluded from the sub span

\code{n0} and \code{n1} numeric to specify the number of periods at the
beginning/end of the series to be used for defining the sub-span
(\code{type} equals to \code{"First"}, \code{"Last"}) or to exclude
(\code{type} equals to \code{"Excluding"}).}

\item{preliminary.check}{a Boolean to check the quality of the input series
and exclude highly problematic ones (e.g. the series with a number of
identical observations and/or missing values above pre-specified threshold
values).}

\item{preprocessing}{(REGARIMA/X13 Specific) a Boolean to enable/disable the pre-processing.
Option disabled for the moment.}
}
\value{
The modified specification with new estimation span
}
\description{
Function allowing to check if the series can be processed and to define a
sub-span on which estimation will be performed
}
\details{
\code{x} specification parameter must be a JD3_X13_SPEC" class object
generated with \code{rjd3x13::x13_spec()} (or "JD3_REGARIMA_SPEC" generated
with \code{rjd3x13::spec_regarima()} or "JD3_TRAMOSEATS_SPEC" generated with
\code{rjd3tramoseats::spec_tramoseats()} or "JD3_TRAMO_SPEC" generated with
\code{rjd3tramoseats::spec_tramo()}).
}
\examples{
\dontshow{if (current_java_version >= minimal_java_version) withAutoprint(\{ # examplesIf}

# Customize a default specification
init_spec <- x13_spec_default

# Estimation on sub-span between two dates (date d1 is excluded)
new_spec <- set_basic(
    init_spec,
    type = "Between",
    d0 = "2014-01-01",
    d1 = "2019-01-01",
    preliminary.check = TRUE,
    preprocessing = TRUE
)

# Estimation on the first 60 observations
new_spec <- set_basic(
    init_spec,
    type = "First",
    n0 = 60,
    preliminary.check = TRUE,
    preprocessing = TRUE
)

# Estimation on the last 60 observations
new_spec <- set_basic(
    init_spec,
    type = "Last",
    n1 = 60,
    preliminary.check = TRUE,
    preprocessing = TRUE
)

# Estimation excluding 60 observations at the beginning and 36 at the end of the series
new_spec <-set_basic(
    init_spec,
    type = "Excluding",
    n0 = 60,
    n1 = 36,
    preliminary.check = TRUE,
    preprocessing = TRUE
)
\dontshow{\}) # examplesIf}
}
\references{
More information in JDemetra+ online documentation:
\url{https://jdemetra-new-documentation.netlify.app/}
}
\seealso{
\code{\link{set_estimate}}, \code{\link{set_arima}}
}
