% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arima.R
\name{sarima_random}
\alias{sarima_random}
\title{Simulate Seasonal ARIMA}
\usage{
sarima_random(model, length, stde = 1, tdegree = 0, seed = -1)
}
\arguments{
\item{model}{a \code{"JD3_SARIMA"} model (see \code{\link[=sarima_model]{sarima_model()}} function).}

\item{length}{length of the output series.}

\item{stde}{deviation of the normal distribution of the innovations of the
simulated series. Unused if \code{tdegree} is larger than 0.}

\item{tdegree}{degrees of freedom of the T distribution of the innovations.
\code{tdegree = 0} if normal distribution is used.}

\item{seed}{seed of the random numbers generator. Negative values mean
random seeds.}
}
\value{
a numeric vector with the simulated series.
}
\description{
Simulate Seasonal ARIMA
}
\examples{
\dontshow{if (current_java_version >= minimal_java_version) withAutoprint(\{ # examplesIf}
# Airline model
s_model <- sarima_model(period = 12, d = 1, bd = 1, theta = 0.2, btheta = 0.2)
x <- sarima_random(s_model, length = 64, seed = 0)
plot(x, type = "l")
\dontshow{\}) # examplesIf}
}
