/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.modelling.highfreq;

import jdplus.toolkit.base.api.timeseries.TimeSelector;
import lombok.Generated;
import lombok.NonNull;
import org.jspecify.annotations.Nullable;

public final class OutlierSpec {
    public static final int DEF_MAXOUTLIERS = 100;
    public static final int DEF_MAXROUND = 100;
    public static final OutlierSpec DEFAULT_DISABLED = OutlierSpec.builder().build();
    public static final OutlierSpec DEFAULT_ENABLED = OutlierSpec.builder().ao(true).ls(true).build();
    private final boolean ao;
    private final boolean ls;
    private final boolean wo;
    private final double criticalValue;
    @NonNull
    private final TimeSelector span;
    private final int maxOutliers;
    private final int maxRound;
    private static final String[] NONE = new String[0];

    public static Builder builder() {
        return new Builder().criticalValue(0.0).maxOutliers(100).maxRound(100).span(TimeSelector.all());
    }

    public boolean isDefault() {
        return this.equals(DEFAULT_DISABLED);
    }

    public boolean isUsed() {
        return this.ao || this.ls || this.wo;
    }

    public String[] allOutliers() {
        int n = 0;
        if (this.ao) {
            ++n;
        }
        if (this.ls) {
            ++n;
        }
        if (this.wo) {
            ++n;
        }
        if (n == 0) {
            return NONE;
        }
        String[] all = new String[n];
        n = 0;
        if (this.ao) {
            all[n++] = "AO";
        }
        if (this.ls) {
            all[n++] = "LS";
        }
        if (this.wo) {
            all[n++] = "WO";
        }
        return all;
    }

    @Generated
    OutlierSpec(boolean ao, boolean ls, boolean wo, double criticalValue, @NonNull TimeSelector span, int maxOutliers, int maxRound) {
        if (span == null) {
            throw new NullPointerException("span is marked non-null but is null");
        }
        this.ao = ao;
        this.ls = ls;
        this.wo = wo;
        this.criticalValue = criticalValue;
        this.span = span;
        this.maxOutliers = maxOutliers;
        this.maxRound = maxRound;
    }

    @Generated
    public @org.jspecify.annotations.NonNull Builder toBuilder() {
        return new Builder().ao(this.ao).ls(this.ls).wo(this.wo).criticalValue(this.criticalValue).span(this.span).maxOutliers(this.maxOutliers).maxRound(this.maxRound);
    }

    @Generated
    public boolean isAo() {
        return this.ao;
    }

    @Generated
    public boolean isLs() {
        return this.ls;
    }

    @Generated
    public boolean isWo() {
        return this.wo;
    }

    @Generated
    public double getCriticalValue() {
        return this.criticalValue;
    }

    @NonNull
    @Generated
    public TimeSelector getSpan() {
        return this.span;
    }

    @Generated
    public int getMaxOutliers() {
        return this.maxOutliers;
    }

    @Generated
    public int getMaxRound() {
        return this.maxRound;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OutlierSpec)) {
            return false;
        }
        OutlierSpec other = (OutlierSpec)o;
        if (this.isAo() != other.isAo()) {
            return false;
        }
        if (this.isLs() != other.isLs()) {
            return false;
        }
        if (this.isWo() != other.isWo()) {
            return false;
        }
        if (Double.compare(this.getCriticalValue(), other.getCriticalValue()) != 0) {
            return false;
        }
        if (this.getMaxOutliers() != other.getMaxOutliers()) {
            return false;
        }
        if (this.getMaxRound() != other.getMaxRound()) {
            return false;
        }
        TimeSelector this$span = this.getSpan();
        TimeSelector other$span = other.getSpan();
        return !(this$span == null ? other$span != null : !((Object)this$span).equals(other$span));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isAo() ? 79 : 97);
        result = result * 59 + (this.isLs() ? 79 : 97);
        result = result * 59 + (this.isWo() ? 79 : 97);
        long $criticalValue = Double.doubleToLongBits(this.getCriticalValue());
        result = result * 59 + (int)($criticalValue >>> 32 ^ $criticalValue);
        result = result * 59 + this.getMaxOutliers();
        result = result * 59 + this.getMaxRound();
        TimeSelector $span = this.getSpan();
        result = result * 59 + ($span == null ? 43 : ((Object)$span).hashCode());
        return result;
    }

    @Generated
    public @org.jspecify.annotations.NonNull String toString() {
        return "OutlierSpec(ao=" + this.isAo() + ", ls=" + this.isLs() + ", wo=" + this.isWo() + ", criticalValue=" + this.getCriticalValue() + ", span=" + String.valueOf(this.getSpan()) + ", maxOutliers=" + this.getMaxOutliers() + ", maxRound=" + this.getMaxRound() + ")";
    }

    @Generated
    public static class Builder {
        @Generated
        private boolean ao;
        @Generated
        private boolean ls;
        @Generated
        private boolean wo;
        @Generated
        private double criticalValue;
        @Generated
        private TimeSelector span;
        @Generated
        private int maxOutliers;
        @Generated
        private int maxRound;

        @Generated
        Builder() {
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder ao(boolean ao) {
            this.ao = ao;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder ls(boolean ls) {
            this.ls = ls;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder wo(boolean wo) {
            this.wo = wo;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder criticalValue(double criticalValue) {
            this.criticalValue = criticalValue;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder span(@NonNull TimeSelector span) {
            if (span == null) {
                throw new NullPointerException("span is marked non-null but is null");
            }
            this.span = span;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder maxOutliers(int maxOutliers) {
            this.maxOutliers = maxOutliers;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder maxRound(int maxRound) {
            this.maxRound = maxRound;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull OutlierSpec build() {
            return new OutlierSpec(this.ao, this.ls, this.wo, this.criticalValue, this.span, this.maxOutliers, this.maxRound);
        }

        @Generated
        public @org.jspecify.annotations.NonNull String toString() {
            return "OutlierSpec.Builder(ao=" + this.ao + ", ls=" + this.ls + ", wo=" + this.wo + ", criticalValue=" + this.criticalValue + ", span=" + String.valueOf(this.span) + ", maxOutliers=" + this.maxOutliers + ", maxRound=" + this.maxRound + ")";
        }
    }
}

