/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf.univariate;

import jdplus.toolkit.base.api.data.DoubleSeqCursor;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.data.DataBlockIterator;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.ssf.DataBlockResults;
import jdplus.toolkit.base.core.ssf.ISsfDynamics;
import jdplus.toolkit.base.core.ssf.ISsfLoading;
import jdplus.toolkit.base.core.ssf.univariate.DefaultFilteringResults;
import jdplus.toolkit.base.core.ssf.univariate.ISsf;

public class FastSmoother {
    private final VarianceFilterProvider vf;
    private final ISsf ssf;
    private final ISsfLoading loading;
    private final ISsfDynamics dynamics;
    private final DataBlock state;
    private final DataBlock R;
    private final DataBlock C;
    private final DataBlockResults A = new DataBlockResults();

    public FastSmoother(ISsf ssf, DefaultFilteringResults frslts) {
        this.ssf = ssf;
        this.vf = VarianceFilterProvider.of(frslts);
        this.loading = ssf.measurement().loading();
        this.dynamics = ssf.dynamics();
        int dim = ssf.getStateDim();
        this.state = DataBlock.make(dim);
        this.R = DataBlock.make(dim);
        this.C = DataBlock.make(dim);
        this.A.prepare(dim, 0, this.vf.size());
    }

    public void smooth(FastMatrix X) {
        DataBlockIterator cols = X.columnsIterator();
        while (cols.hasNext()) {
            this.smooth(cols.next());
        }
    }

    public void smooth(DataBlock x) {
        this.forwardFilter(x);
        this.backwardFilter(x);
    }

    void forwardFilter(DataBlock x) {
        int n = this.vf.size();
        int pos = 0;
        this.ssf.initialization().a0(this.state);
        DoubleSeqCursor.OnMutable cursor = x.cursor();
        while (pos < n) {
            int cur = pos++;
            cursor.applyAndNext(z -> this.iterateFilter(cur, z));
        }
    }

    private double iterateFilter(int i, double x) {
        double f;
        this.A.save(i, this.state);
        boolean missing = this.vf.isMissing(i);
        double fx = x - this.loading.ZX(i, this.state);
        if (!missing && (f = this.vf.errorVariance(i)) > 0.0) {
            DataBlock C = this.vf.M(i);
            this.state.addAY(fx / f, C);
        }
        this.dynamics.TX(i, this.state);
        return fx;
    }

    void backwardFilter(DataBlock x) {
        int t = x.length();
        while (--t >= 0) {
            x.set(t, this.iterateSmoother(t, x.get(t)));
        }
    }

    private double iterateSmoother(int pos, double fx) {
        double f = this.vf.errorVariance(pos);
        this.C.copy(this.vf.M(pos));
        this.C.mul(1.0 / f);
        boolean missing = this.vf.isMissing(pos);
        this.dynamics.XT(pos, this.R);
        if (!missing) {
            double u = fx / f - this.R.dot(this.C);
            this.loading.XpZd(pos, this.R, u);
        }
        this.state.copy(this.A.datablock(pos));
        this.state.addProduct(this.R, this.vf.P(pos).columnsIterator());
        return this.loading.ZX(pos, this.state);
    }

    public static interface VarianceFilterProvider {
        public int size();

        public boolean isMissing(int var1);

        public double errorVariance(int var1);

        public DataBlock M(int var1);

        public FastMatrix P(int var1);

        public static VarianceFilterProvider of(final DefaultFilteringResults fr2) {
            return new VarianceFilterProvider(){

                @Override
                public int size() {
                    return fr2.size();
                }

                @Override
                public boolean isMissing(int pos) {
                    return fr2.isMissing(pos);
                }

                @Override
                public double errorVariance(int pos) {
                    return fr2.errorVariance(pos);
                }

                @Override
                public DataBlock M(int pos) {
                    return fr2.M(pos);
                }

                @Override
                public FastMatrix P(int pos) {
                    return fr2.P(pos);
                }
            };
        }
    }
}

