/*
 * Decompiled with CFR 0.152.
 */
package standalone_spreadsheet.com.github.rzymek.opczip.reader.skipping;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.nio.charset.StandardCharsets;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipEntry;
import standalone_spreadsheet.com.github.rzymek.opczip.reader.InputStreamUtils;
import standalone_spreadsheet.com.github.rzymek.opczip.reader.skipping.CompressedEntryInputStream;
import standalone_spreadsheet.com.github.rzymek.opczip.reader.skipping.ExactIO;
import standalone_spreadsheet.com.github.rzymek.opczip.reader.skipping.Signature;
import standalone_spreadsheet.com.github.rzymek.opczip.reader.skipping.ZipReadSpec;

public class ZipStreamReader
implements AutoCloseable {
    private final PushbackInputStream in;
    private int flag;
    private boolean reachedCEN = false;
    protected ZipEntry currentEntry;

    public ZipStreamReader(InputStream in) {
        this.in = new PushbackInputStream(in, 8192);
    }

    public ZipEntry nextEntry() throws IOException {
        long crc;
        long size;
        if (this.reachedCEN) {
            return null;
        }
        byte[] lfh = ZipReadSpec.readNBytes(this.in, 30);
        if (ZipReadSpec.CEN.matchesStartOf(lfh)) {
            this.reachedCEN = true;
            return null;
        }
        if (!ZipReadSpec.LFH.matchesStartOf(lfh)) {
            String msg = "Expecting LFH bytes (" + ZipReadSpec.LFH + "). Got " + Signature.toString(lfh, ZipReadSpec.LFH.length());
            throw new IOException(msg);
        }
        this.flag = ZipReadSpec.get16(lfh, 6);
        int nameLen = ZipReadSpec.get16(lfh, 26);
        byte[] filename = ZipReadSpec.readNBytes(this.in, nameLen);
        this.currentEntry = new ZipEntry(new String(filename, StandardCharsets.US_ASCII));
        long csize = ZipReadSpec.get32(lfh, 18);
        if (csize != 0L) {
            this.currentEntry.setCompressedSize(csize);
        }
        if ((size = ZipReadSpec.get32(lfh, 22)) != 0L) {
            this.currentEntry.setSize(size);
        }
        if ((crc = ZipReadSpec.get32(lfh, 14)) != 0L) {
            this.currentEntry.setCrc(crc);
        }
        int extLen = ZipReadSpec.get16(lfh, 28);
        ExactIO.skipExactly(this.in, extLen);
        return this.currentEntry;
    }

    public void skipStream() throws IOException {
        long compressedSize = this.currentEntry.getCompressedSize();
        if (compressedSize > 0L) {
            ExactIO.skipExactly(this.in, compressedSize + (long)(this.expectingDatSig() ? 16 : 0));
        } else {
            InputStreamUtils.discardAllBytes(this.getCompressedStream());
        }
    }

    public InflaterInputStream getUncompressedStream() {
        return ZipStreamReader.uncompressed(this.getCompressedStream());
    }

    public static InflaterInputStream uncompressed(InputStream compressedStream) {
        return new InflaterInputStream(compressedStream, new Inflater(true));
    }

    public InputStream getCompressedStream() {
        if (this.reachedCEN) {
            return null;
        }
        return new CompressedEntryInputStream(this.in, this.currentEntry, this.expectingDatSig());
    }

    private boolean expectingDatSig() {
        return (this.flag & 8) != 0;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }
}

