/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.tsp.fixme;

import java.io.File;
import java.nio.file.Path;
import java.util.Locale;
import java.util.Objects;
import lombok.Generated;
import lombok.NonNull;
import org.jspecify.annotations.Nullable;

public final class Files2 {
    public static File fromPath(String parent, String ... path) {
        return Path.of(parent, String.join((CharSequence)File.separator, path)).toFile();
    }

    public static @Nullable File getAbsoluteFile(@NonNull File[] paths, @NonNull File file) {
        if (paths == null) {
            throw new NullPointerException("paths is marked non-null but is null");
        }
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        if (file.isAbsolute()) {
            return file;
        }
        for (File parent : paths) {
            File result = parent.toPath().resolve(file.getPath()).toFile();
            if (!result.exists()) continue;
            return result;
        }
        return null;
    }

    public static @Nullable File getRelativeFile(@NonNull File[] paths, @NonNull File file) {
        if (paths == null) {
            throw new NullPointerException("paths is marked non-null but is null");
        }
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        if (!file.isAbsolute()) {
            return file;
        }
        String path = file.getAbsolutePath();
        for (File parent : paths) {
            String parentPath = parent.getAbsolutePath() + File.separator;
            if (!path.startsWith(parentPath)) continue;
            return Path.of(path.substring(parentPath.length()), new String[0]).toFile();
        }
        return null;
    }

    public static String getFileExtension(File file) {
        Objects.requireNonNull(file);
        String name = file.getName();
        int index = name.lastIndexOf(46);
        return index != -1 ? name.substring(index + 1) : "";
    }

    public static boolean acceptByLowerCaseExtension(File pathname, String ... lowerCaseExtensions) {
        String ext = Files2.getFileExtension(pathname).toLowerCase(Locale.ENGLISH);
        for (String o : lowerCaseExtensions) {
            if (!ext.equals(o)) continue;
            return true;
        }
        return false;
    }

    public static @Nullable File extractFile(@NonNull String path) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        try {
            File result;
            for (result = Path.of(path, new String[0]).toFile(); result != null && !result.exists(); result = result.getParentFile()) {
            }
            return result;
        }
        catch (RuntimeException ignore) {
            return null;
        }
    }

    @Generated
    private Files2() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

