% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{BRCA2_mam}
\alias{BRCA2_mam}
\title{Cumulative risk of breast cancer in women with the BRCA2 mutation.}
\format{
A data frame (63 x 2).

\code{age}: age (in years).

\code{cumRisk}: cumulative risk of developing breast
cancer in this (BRCA2) population.
}
\source{
Based on Figure 2 (p. 2408) of
Kuchenbaecker, K. B., Hopper, J. L., Barnes, D. R., Phillips, K. A., Mooij, T. M., Roos-Blom, M. J., ... & BRCA1 and BRCA2 Cohort Consortium (2017).
Risks of breast, ovarian, and contralateral breast cancer for BRCA1 and BRCA2 mutation carriers. \emph{JAMA}, \emph{317} (23), 2402--2416.
doi: 10.1001/jama.2017.7112
}
\usage{
BRCA2_mam
}
\description{
\code{BRCA2_mam} provides the cumulative risk of breast cancer
in a population of women with the BRCA2 mutation
as a function of their age (in years).
}
\seealso{
\code{\link{plot_crisk}} plots cumulative risk curves.

Other datasets: 
\code{\link{BRCA1}},
\code{\link{BRCA1_mam}},
\code{\link{BRCA1_ova}},
\code{\link{BRCA2}},
\code{\link{BRCA2_ova}},
\code{\link{df_scenarios}},
\code{\link{t_A}},
\code{\link{t_B}},
\code{\link{t_I}}
}
\concept{datasets}
\keyword{datasets}
