% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/progress_utils.R
\name{with_progress_signal}
\alias{with_progress_signal}
\title{Execute Function with Progress Reporting for Each Item}
\usage{
with_progress_signal(.f, .p)
}
\arguments{
\item{.f}{Function to wrap}

\item{.p}{Progressor function created by \code{create_progressor()} or \code{progressr::progressor()}}
}
\value{
A wrapped function that calls \code{.f(x)} and then signals progress via \code{.p()}.
}
\description{
Helper function that wraps a function to report progress after each invocation.
Useful for integrating progress reporting with \code{purrr::map()} or \code{furrr::future_map()}.
}
\details{
This is an internal utility function used by riemtan's parallel processing functions.
}
\examples{
\dontrun{
progressr::handlers("progress")

result <- with_progress({
  p <- progressr::progressor(steps = 10)
  wrapped_fn <- with_progress_signal(sqrt, p)
  lapply(1:10, wrapped_fn)
})
}

}
\keyword{internal}
