% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timescales.R
\name{F14CtoC14}
\alias{F14CtoC14}
\title{Calculate C14 ages from F14C values.}
\usage{
F14CtoC14(F14C, er = NULL, roundby = NA, lambda = 8033, botherrors = FALSE)
}
\arguments{
\item{F14C}{Reported mean of the F14C}

\item{er}{Reported error of the F14C. Returns just the mean if left empty.}

\item{roundby}{Amount of decimals required for the output. Defaults to \code{roundby=NA}, no rounding.}

\item{lambda}{The mean-life of radiocarbon (based on Libby half-life of 5568 years).}

\item{botherrors}{Since going from C14 to F14C involves a logarithmic transformation (F=exp(-y/lambda)), errors that are symmetric on the C14 scale will become asymmetric on the F14C scale. By default, only the largest error is reported, but if \code{reportbotherrors=TRUE}, both errors are reported. #' @return The radiocarbon ages from the F14C values. If F14C values are above 100\%, the resulting radiocarbon ages will be negative.}
}
\description{
Calculate C14 ages from F14C values of radiocarbon dates.
}
\details{
Post-bomb dates are often reported as F14C (between 0 at c. 55 kcal BP and 1 at c. AD 1950). Since software such as Bacon expects radiocarbon ages,
 this function can be used to calculate radiocarbon ages from F14C values. The reverse function is \link{age.F14C}.
}
\examples{
  F14CtoC14(1.10, 0.005) # a postbomb date, so with a negative C14 age
  F14CtoC14(.80, 0.005) # prebomb dates can also be calculated
}
