% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tensor.R
\name{as_a}
\alias{as_a}
\title{Strip array labels}
\usage{
as_a(x, ...)
}
\arguments{
\item{x}{A labeled array ("tensor" object) created by \code{\link{\%_\%}} or \code{\link[=tensor]{tensor()}}.}

\item{...}{Index labels separated by commas optionally prefixed by "+" and "-"
to indicate the index position (upper and lower respectively).
If no prefix is provided, a lower index ("-") is assumed.
This argument uses non-standard evaluation: any R symbol
that is not a reserved keyword can be used.
The specification needs to match all the labels occurring in \code{x}.
The label order determines the dimension
ordering of the resulting array.}
}
\value{
A usual \code{\link[=array]{array()}} without attached labels. The dimension order is
determined by \code{...}.
}
\description{
Converts a \code{\link[=tensor]{tensor()}} to an \code{\link[=array]{array()}} by stripping the index labels.
An index label order
needs to be provided so that the array's \code{\link[=dim]{dim()}} order is well defined.
}
\examples{
array(1:8, dim = c(2, 2, 2)) \%_\% .(i, +i, k) |> as_a(k)
}
\seealso{
The same functionality is implemented in \code{\link[=as.array.tensor]{as.array.tensor()}}
but with standard evaluation.
}
\concept{tensor_dest}
