/*
 * Decompiled with CFR 0.152.
 */
package usf.saav.common.jocl;

import java.util.Arrays;
import java.util.Objects;
import org.jocl.CL;
import org.jocl.CLException;
import org.jocl.NativePointerObject;
import org.jocl.Pointer;
import org.jocl.Sizeof;
import org.jocl.cl_command_queue;
import org.jocl.cl_context;
import org.jocl.cl_event;
import org.jocl.cl_kernel;
import org.jocl.cl_program;
import org.jocl.cl_sampler;
import usf.saav.common.jocl.joclDevice;
import usf.saav.common.jocl.joclEvent;
import usf.saav.common.jocl.joclException;
import usf.saav.common.jocl.joclImage;
import usf.saav.common.jocl.joclLoader;
import usf.saav.common.jocl.joclMemory;

public class joclKernel {
    private cl_kernel kernel = null;
    private joclDevice device = null;
    private String name;

    joclKernel(joclDevice joclDevice2, String string, String string2) {
        this.init(joclDevice2, string, string2);
    }

    joclKernel(joclDevice joclDevice2, joclLoader joclLoader2, String string) {
        this.init(joclDevice2, joclLoader2.toString(), string);
    }

    joclKernel(joclDevice joclDevice2, String[] stringArray, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string2 : stringArray) {
            stringBuilder.append(string2 + "\n");
        }
        this.init(joclDevice2, stringBuilder.toString(), string);
    }

    private void init(joclDevice joclDevice2, String string, String string2) {
        this.name = string2;
        cl_program cl_program2 = CL.clCreateProgramWithSource((cl_context)joclDevice2.context, (int)1, (String[])new String[]{string}, null, null);
        try {
            CL.clBuildProgram((cl_program)cl_program2, (int)0, null, null, null, null);
        }
        catch (CLException cLException) {
            System.err.println("Compile error: " + string2);
            cLException.printStackTrace();
            System.exit(0);
        }
        this.device = joclDevice2;
        this.kernel = CL.clCreateKernel((cl_program)cl_program2, (String)string2, null);
    }

    public void setKernelArg(int n, float ... fArray) throws joclException {
        if (CL.clSetKernelArg((cl_kernel)this.kernel, (int)n, (long)(fArray.length * 4), (Pointer)Pointer.to((float[])fArray)) != 0) {
            throw new joclException();
        }
    }

    public void setKernelArg(int n, int ... nArray) throws joclException {
        if (CL.clSetKernelArg((cl_kernel)this.kernel, (int)n, (long)(nArray.length * 4), (Pointer)Pointer.to((int[])nArray)) != 0) {
            throw new joclException();
        }
    }

    public void setKernelArg(int n, cl_sampler cl_sampler2) throws joclException {
        if (CL.clSetKernelArg((cl_kernel)this.kernel, (int)n, (long)Sizeof.cl_sampler, (Pointer)Pointer.to((NativePointerObject)cl_sampler2)) != 0) {
            throw new joclException();
        }
    }

    public void setKernelArg(int n, joclMemory joclMemory2) throws joclException {
        if (CL.clSetKernelArg((cl_kernel)this.kernel, (int)n, (long)Sizeof.cl_mem, (Pointer)Pointer.to((NativePointerObject)joclMemory2.memory)) != 0) {
            throw new joclException();
        }
    }

    public void setKernelArg(int n, joclImage joclImage2) throws joclException {
        if (CL.clSetKernelArg((cl_kernel)this.kernel, (int)n, (long)Sizeof.cl_mem, (Pointer)Pointer.to((NativePointerObject)joclImage2.memory)) != 0) {
            throw new joclException();
        }
    }

    public void setKernelArgs(KernelArg ... kernelArgArray) throws joclException {
        for (int i = 0; i < kernelArgArray.length; ++i) {
            if (CL.clSetKernelArg((cl_kernel)this.kernel, (int)i, (long)kernelArgArray[i].size, (Pointer)kernelArgArray[i].pntr) == 0) continue;
            throw new joclException();
        }
    }

    public joclEvent enqueueNDRangeKernel(long[] lArray, cl_event ... cl_eventArray) throws joclException {
        return this.enqueueNDRangeKernel(lArray, Arrays.copyOf(lArray, lArray.length), cl_eventArray);
    }

    public joclEvent enqueueNDRangeKernel(long[] lArray, long[] lArray2, cl_event ... cl_eventArray) throws joclException {
        int n;
        long[] lArray3 = Arrays.copyOf(lArray2, lArray2.length);
        long[] lArray4 = this.device.getMaxWorkDimensionSizes();
        long l = this.device.getMaxWorkSize();
        long l2 = 1L;
        for (n = 0; n < lArray3.length; ++n) {
            lArray3[n] = Math.min(lArray3[n], lArray4[n]);
            l2 *= lArray3[n];
        }
        n = 0;
        while (l2 > l) {
            lArray3[n] = Math.max(lArray3[n] / 2L, 1L);
            n = (n + 1) % lArray3.length;
            l2 = 1L;
            for (int i = 0; i < lArray3.length; ++i) {
                l2 *= lArray3[i];
            }
        }
        cl_event cl_event2 = new cl_event();
        if (cl_eventArray.length == 0 ? CL.clEnqueueNDRangeKernel((cl_command_queue)this.device.commandQueue, (cl_kernel)this.kernel, (int)lArray.length, null, (long[])lArray, (long[])lArray3, (int)0, null, (cl_event)cl_event2) != 0 : CL.clEnqueueNDRangeKernel((cl_command_queue)this.device.commandQueue, (cl_kernel)this.kernel, (int)lArray.length, null, (long[])lArray, (long[])lArray3, (int)cl_eventArray.length, (cl_event[])cl_eventArray, (cl_event)cl_event2) != 0) {
            throw new joclException();
        }
        return new joclEvent(this.name, cl_event2);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        int[] nArray = new int[]{0};
        long[] lArray = new long[]{0L};
        long[] lArray2 = new long[]{0L};
        byte[] byArray = new byte[1024];
        CL.clGetKernelInfo((cl_kernel)this.kernel, (int)4497, (long)4L, (Pointer)Pointer.to((int[])nArray), null);
        int n = nArray[0];
        for (int i = 0; i < n; ++i) {
            CL.clGetKernelArgInfo((cl_kernel)this.kernel, (int)i, (int)4506, (long)0L, null, (long[])lArray2);
            CL.clGetKernelArgInfo((cl_kernel)this.kernel, (int)i, (int)4506, (long)lArray2[0], (Pointer)Pointer.to((byte[])byArray), null);
            String string = new String(byArray, 0, (int)lArray2[0] - 1);
            CL.clGetKernelArgInfo((cl_kernel)this.kernel, (int)i, (int)4502, (long)4L, (Pointer)Pointer.to((int[])nArray), null);
            int n2 = nArray[0];
            CL.clGetKernelArgInfo((cl_kernel)this.kernel, (int)i, (int)4503, (long)4L, (Pointer)Pointer.to((int[])nArray), null);
            int n3 = nArray[0];
            CL.clGetKernelArgInfo((cl_kernel)this.kernel, (int)i, (int)4505, (long)8L, (Pointer)Pointer.to((long[])lArray), null);
            long l = lArray[0];
            CL.clGetKernelArgInfo((cl_kernel)this.kernel, (int)i, (int)4504, (long)0L, null, (long[])lArray2);
            CL.clGetKernelArgInfo((cl_kernel)this.kernel, (int)i, (int)4504, (long)lArray2[0], (Pointer)Pointer.to((byte[])byArray), null);
            String string2 = new String(byArray, 0, (int)lArray2[0] - 1);
            stringBuilder.append("Argument " + i + ":");
            stringBuilder.append("    Name: " + string);
            stringBuilder.append("    Address qualifier: " + CL.stringFor_cl_kernel_arg_address_qualifier((int)n2));
            stringBuilder.append("    Access qualifier : " + CL.stringFor_cl_kernel_arg_access_qualifier((int)n3));
            stringBuilder.append("    Type qualifier   : " + CL.stringFor_cl_kernel_arg_type_qualifer((long)l));
            stringBuilder.append("    Type name        : " + string2);
        }
        return stringBuilder.toString();
    }

    public class KernelArg {
        Pointer pntr;
        long size;

        public KernelArg(joclKernel joclKernel2, float ... fArray) {
            Objects.requireNonNull(joclKernel2);
            this.size = fArray.length * 4;
            this.pntr = Pointer.to((float[])fArray);
        }

        public KernelArg(joclKernel joclKernel2, int ... nArray) {
            Objects.requireNonNull(joclKernel2);
            this.size = nArray.length * 4;
            this.pntr = Pointer.to((int[])nArray);
        }

        public KernelArg(joclKernel joclKernel2, cl_sampler cl_sampler2) {
            Objects.requireNonNull(joclKernel2);
            this.size = Sizeof.cl_sampler;
            this.pntr = Pointer.to((NativePointerObject)cl_sampler2);
        }

        public KernelArg(joclKernel joclKernel2, joclMemory joclMemory2) {
            Objects.requireNonNull(joclKernel2);
            this.size = Sizeof.cl_mem;
            this.pntr = Pointer.to((NativePointerObject)joclMemory2.memory);
        }

        public KernelArg(joclKernel joclKernel2, joclImage joclImage2) {
            Objects.requireNonNull(joclKernel2);
            this.size = Sizeof.cl_mem;
            this.pntr = Pointer.to((NativePointerObject)joclImage2.memory);
        }
    }
}

