% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gads_get_account_hierarchy.R
\name{gads_get_account_hierarchy}
\alias{gads_get_account_hierarchy}
\title{Get Google Ads Manager Account Hierarchy}
\usage{
gads_get_account_hierarchy(
  manager_customer_id = getOption("gads.login.customer.id"),
  include_drafts = FALSE,
  login_customer_id = getOption("gads.login.customer.id")
)
}
\arguments{
\item{manager_customer_id}{ID of the manager account whose hierarchy you want to get.}

\item{include_drafts}{logical, Incliding drafts child account.}

\item{login_customer_id}{Ypor top-level manager account id.}
}
\value{
tibble with data of all the child accounts
}
\description{
Get Google Ads Manager Account Hierarchy
}
\examples{
\dontrun{
acc_hier <- gads_get_account_hierarchy(
    manager_customer_id = '111-111-1111',
    login_customer_id   = '000-000-0000')
}
}
\seealso{
\href{https://developers.google.com/google-ads/api/docs/account-management/get-account-hierarchy}{Get Account Hierarchy API documentation}
}
