% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{metconv2zmcomp}
\alias{metconv2zmcomp}
\title{Convert meteorological wind speed and direction to u/v components}
\usage{
metconv2zmcomp(speed, direction, names = c("uwnd", "vwnd"))
}
\arguments{
\item{speed}{Numeric vector of wind speeds.}

\item{direction}{Numeric vector of wind directions in degrees (0° = from north,
90° = from east, 180° = from south, 270° = from west).}

\item{names}{(optional) ames to construct the resulting data.frame.}
}
\value{
A data.frame with two columns:
\describe{
\item{u}{Zonal wind component (m/s), positive eastward.}
\item{v}{Meridional wind component (m/s), positive northward.}
}
}
\description{
Converts wind speed (magnitude) and direction (in degrees, meteorological
convention: direction from which the wind blows, measured clockwise from north)
into zonal (u) and meridional (v) components.
}
\examples{
# Example 1: North wind of 10 m/s (blowing southward)
metconv2zmcomp(10, 0)

# Example 2: East wind of 5 m/s (blowing westward)
metconv2zmcomp(5, 90)

# Example 3: South wind of 8 m/s (blowing northward)
metconv2zmcomp(8, 180)

}
