% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/refdb_checks.R
\name{refdb_report}
\alias{refdb_report}
\title{Compile a report with different checks}
\usage{
refdb_report(x, file = NULL, view = TRUE)
}
\arguments{
\item{x}{a reference database.}

\item{file}{the file (path) to write the report. If \code{NULL}
the report is written in the user temp directory.}

\item{view}{A logical. If \code{TRUE} (default), the file is instantly
opened in the web browser.}
}
\value{
The function invisibly returns the file where the report was written.
}
\description{
This function produce an HTML report to investigate potential issues
in a reference database.
}
\examples{

lib <- read.csv(system.file("extdata", "ephem.csv", package = "refdb"))
lib <- refdb_set_fields(lib,
                        taxonomy = c(family = "family_name",
                            genus = "genus_name",
                            species = "species_name"),
                        sequence = "DNA_seq",
                        marker = "marker")
tmp <- tempfile()

refdb_report(lib, tmp, view = FALSE)

}
