% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/refdb_fill_taxo.R
\name{refdb_fill_tax_upstream}
\alias{refdb_fill_tax_upstream}
\title{Fill missing data in taxonomy}
\usage{
refdb_fill_tax_upstream(x, qualifier = "undef.")
}
\arguments{
\item{x}{a reference database.}

\item{qualifier}{a string to add the new labels.
Default ensure that \code{refdb_clean_tax_NA} will correctly
identify the label as NA.}
}
\value{
A reference database.
}
\description{
Replace NA values in taxonomic classification
using downstream ranks.
}
\examples{
lib <- read.csv(system.file("extdata", "baetidae_bold.csv", package = "refdb"))
lib <- refdb_set_fields_BOLD(lib)
refdb_fill_tax_upstream(lib)

}
\seealso{
refdb_fill_tax_downstream to replace terminal NA values
using upstream data.
}
