% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constructLinkToRedcapForm.R
\name{constructLinkToRedcapForm}
\alias{constructLinkToRedcapForm}
\alias{constructLinkToRedcapForm.redcapApiConnection}
\alias{constructLinkToRedcapForm.redcapOfflineConnection}
\title{Construct a Link to a REDCap Form}
\usage{
constructLinkToRedcapForm(rcon, form_name, record_id, event_id = NULL, ...)

\method{constructLinkToRedcapForm}{redcapApiConnection}(rcon, form_name, record_id, event_id = NULL, ...)

\method{constructLinkToRedcapForm}{redcapOfflineConnection}(rcon, form_name, record_id, event_id = NULL, ...)
}
\arguments{
\item{rcon}{A \code{redcapConnection} object.}

\item{form_name}{\code{character}. The name of the form on which the field
name exists.}

\item{record_id}{\code{character}. The ID of the record being linked to.
If passed as a numeric value, it will be coerced to character.
Must have the same length as \code{form_name}.}

\item{event_id}{\code{character} or \code{NULL}. For classical projects, use either
\code{NULL} or \code{NA} (\code{NA} support is permitted to assist with vectorization).
For longitudinal projects, the ID of the unique event. If passed
as a numeric value, it will be coerced to character.}

\item{...}{Arguments to pass to other methods}
}
\value{
Returns a character vector the same length of \code{form_name}.
}
\description{
Uses information from the project and a record to link to
the form on which a data element is recorded. This is intended to be used
within the report of invalid results when exporting or importing
records. It should be noted that when importing records, the records
may not yet exist and the links may not work.
}
\details{
Constructing a link to a REDCap form requires knowledge of the
following:
\itemize{
\item The REDCap instance url (usually 'redcap.institution.domain').
\item The REDCap instance version number.
\item The REDCap project ID number
\item The record ID
\item The form name
\item The event ID number (if the project is longitudinal).
}

If any of these items in unknown, a missing value will be returned. For
\code{redcapOfflineConnection}s, the user will need to provide the version
number, the project information, and the events (if the project
is longitudinal) as part of the call to \code{offlineConnection}. Note that
the REDCap User Interface does not include the event ID number with the
file download for events.
}
