% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/source.R
\name{datasource}
\alias{datasource}
\title{Create a source object.}
\usage{
datasource(
  file,
  skip = 0,
  skip_empty_rows = FALSE,
  comment = "",
  skip_quote = TRUE
)
}
\arguments{
\item{file}{Either a path to a file, a connection, or literal data
(either a single string or a raw vector).

Files ending in \code{.gz}, \code{.bz2}, \code{.xz}, or \code{.zip} will
be automatically uncompressed. Files starting with \verb{http://},
\verb{https://}, \verb{ftp://}, or \verb{ftps://} will be automatically
downloaded. Remote \code{.gz} files can also be automatically downloaded and
decompressed.

Literal data is most useful for examples and tests. To be recognised as
literal data, wrap the input with \code{I()}.

Using a value of \code{\link[=clipboard]{clipboard()}} will read from the system clipboard.}

\item{skip}{Number of lines to skip before reading data.}
}
\description{
Create a source object.
}
\examples{
# Literal csv
datasource("a,b,c\n1,2,3")
datasource(charToRaw("a,b,c\n1,2,3"))

# Strings
datasource(readr_example("mtcars.csv"))
datasource(readr_example("mtcars.csv.bz2"))
datasource(readr_example("mtcars.csv.zip"))
\dontrun{
datasource("https://github.com/tidyverse/readr/raw/main/inst/extdata/mtcars.csv")
}

# Connection
con <- rawConnection(charToRaw("abc\n123"))
datasource(con)
close(con)
}
\keyword{internal}
