% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{hrrp_keydates}
\alias{hrrp_keydates}
\alias{hrrp_performance_periods}
\alias{hrrp_payment_periods}
\alias{hrrp_review_periods}
\alias{hrrp_snapshot_dates}
\alias{hrrp_cohort_inclusion}
\title{Key dates from the Hospital Readmissions Reduction Program (HRRP)}
\format{
\subsection{\code{hrrp_performance_periods}}{

Start and end dates for discharges evaluated for readmissions. Note some program years
have multiple performance intervals and are represented on separate rows of this table.
}

\subsection{\code{hrrp_payment_periods}}{

Start and end dates for when payment penalties are applied by CMS to hospital reimbursement.
}

\subsection{\code{hrrp_review_periods}}{

Start and end dates for the review and correction period where hospitals could review discharge-level data
and downstream calculations of penalty amounts.
}

\subsection{\code{hrrp_snapshot_dates}}{

The \emph{as of} date for when claims data were extracted by CMS for evaluation in the program. \emph{Note some discrepancies
exist in CMS documentation for these dates (e.g., FY2026) when comparing anticipated versus actual snapshot date. The
latter was used in this case.}
}

\subsection{\code{hrrp_cohort_inclusion}}{

Indicators of whether each cohort was included in the program for the given year. \code{1} = included, \code{0} = excluded.
\describe{
\item{AMI}{Acute Myocardial Infarction}
\item{COPD}{Chronic Obstructive Pulmonary Disease}
\item{HF}{Heart Failure}
\item{PN}{Pneumonia}
\item{CABG}{Coronary Artery Bypass Graft}
\item{HK}{Total Hip/Knee Replacement}
}
}

\subsection{\code{hrrp_keydates}}{

A combined table that joins all of the above individual tables into a single common table with altered column names.
}

An object of class \code{tbl_df} (inherits from \code{tbl}, \code{data.frame}) with 11 rows and 3 columns.

An object of class \code{tbl_df} (inherits from \code{tbl}, \code{data.frame}) with 9 rows and 3 columns.

An object of class \code{tbl_df} (inherits from \code{tbl}, \code{data.frame}) with 8 rows and 3 columns.

An object of class \code{tbl_df} (inherits from \code{tbl}, \code{data.frame}) with 9 rows and 2 columns.

An object of class \code{tbl_df} (inherits from \code{tbl}, \code{data.frame}) with 9 rows and 7 columns.
}
\source{
\url{https://qualitynet.cms.gov/inpatient/hrrp/resources#tab1}
}
\usage{
hrrp_keydates

hrrp_performance_periods

hrrp_payment_periods

hrrp_review_periods

hrrp_snapshot_dates

hrrp_cohort_inclusion
}
\description{
A collection of datasets giving important dates involved in the \href{https://www.cms.gov/medicare/payment/prospective-payment-systems/acute-inpatient-pps/hospital-readmissions-reduction-program-hrrp}{Hospital Readmissions Reduction Program (HRRP)},
including performance periods, payment periods, review and correction periods, claims snapshot dates, and cohort inclusion
status for program years since 2019. The data is manually abstracted from \href{https://qualitynet.cms.gov/inpatient/hrrp/resources#tab1}{QualityNet} and
was most recently updated on 11/21/2025.

All tables contain the \code{ProgramYear}, which is the HRRP program (or federal fiscal year) in question.
Tables with date ranges contain a \code{StartDate} and \code{EndDate} contain the beginning and end dates of the
respective interval. Other tables contain individual dates or indicators for cohort inclusion (see descriptions).
}
\keyword{datasets}
