% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readDWD.R
\name{readDWD.hyras}
\alias{readDWD.hyras}
\title{read dwd hyras netcdf data}
\usage{
readDWD.hyras(file, quiet = rdwdquiet(), ...)
}
\arguments{
\item{file}{Name of file on harddrive, like e.g.
DWDdata/monthly_hyras_de_humidity_hurs_hyras_5_2020_v5-0_de_monmean.nc}

\item{quiet}{Currently not used.
DEFAULT: FALSE through \code{\link[=rdwdquiet]{rdwdquiet()}}}

\item{\dots}{Further arguments passed to \code{\link[terra:rast]{terra::rast()}}}
}
\value{
\code{\link[terra:rast]{terra::rast()}} object.
}
\description{
Read hyras netcdf data.
Intended to be called via \code{\link[=readDWD]{readDWD()}}.\cr
Note that \code{terra} must be installed to read the .nc files.
}
\examples{
\dontrun{ # Excluded from CRAN checks, but run in localtests
link <- "monthly/hyras_de/humidity/hurs_hyras_5_2020_v5-0_de_monmean.nc"
hyras <- dataDWD(link, gridbase, joinbf=TRUE) # 0.9MB
plotRadar(hyras, proj="nc", extent=NULL, 
          main=substr(terra::time(hyras),1,7), layer=1:2)
}
}
\seealso{
\code{\link[=readDWD.nc]{readDWD.nc()}} for packed .nc.gz files, \code{\link[=readDWD]{readDWD()}}
}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, Jun 2023
}
