% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rcatfish_classification.R
\name{rcatfish_classification}
\alias{rcatfish_classification}
\title{Access the Eschmeyer's Catalog of Fishes Classification}
\usage{
rcatfish_classification()
}
\value{
A dataframe with seven columns. From left to right (and most inclusive to least inclusive), the columns represent class, order, suborder, family, subfamily, author, and the common name of the family or subfamily.
}
\description{
This function is used to access the Eschmeyer's Catalog of Fishes classification of fishes
}
\details{
This function displays the classification tab of Eschmeyer's Catalog of Fishes. The data are returned in a tabular framework that progresses from most to least inclusive from left to right. The function will return the class, order, suborder, family, subfamily, author, and common name of the family or subfamily.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
#Obtain the Eschmeyer's Catalog of Fishes Classification
\donttest{
myClassification <- rcatfish_classification()
}
\dontshow{\}) # examplesIf}
}
\references{
van der Laan, R., Fricke, R. & Eschmeyer, W.N. (Year Accessed). Eschmeyer's Catalog of Fishes: Classification. https://www.calacademy.org/scientists/catalog-of-fishes-classification/.
}
\author{
Samuel R. Borstein
}
