% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/one_mean_size.R
\name{one_mean_size}
\alias{one_mean_size}
\title{Sample Size or Power for One-Sample Mean Test}
\usage{
one_mean_size(
  mu,
  mu0,
  delta = NULL,
  sd,
  alpha,
  beta = NULL,
  n = NULL,
  test_type = "2-side"
)
}
\arguments{
\item{mu}{Numeric. True mean.}

\item{mu0}{Numeric. Null hypothesis mean.}

\item{delta}{Numeric (optional). Margin for \code{"non-inferiority"} or \code{"equivalence"} test. Required for \code{"non-inferiority"} or \code{"equivalence"} test.}

\item{sd}{Numeric. Standard deviation.}

\item{alpha}{Numeric. Type I error rate.}

\item{beta}{Numeric (optional). Type II error rate. Required for sample size calculation.}

\item{n}{Integer (optional). Sample size. Required for power calculation.}

\item{test_type}{Character. \code{"2-side"}, \code{"1-side"}, \code{"non-inferiority"}, or \code{"equivalence"}. Default is \code{"2-side"}.}
}
\value{
Numeric. Returns sample size (if \code{beta} is given), or power (if \code{n} is given).
}
\description{
Calculates sample size or power for a one-sample mean test.
}
\note{
Only one of \code{beta} (for sample size calculation) or \code{n} (for power calculation) should be specified.

Required arguments by \code{test_type}:
\itemize{
\item \code{"2-side"} / \code{"1-side"}:
\itemize{
\item For sample size: \code{mu}, \code{mu0}, \code{sd}, \code{alpha}, \code{beta}
\item For power: \code{mu}, \code{mu0}, \code{sd}, \code{alpha}, \code{n}
}
\item \code{"non-inferiority"} / \code{"equivalence"}:
\itemize{
\item For sample size: \code{mu}, \code{mu0}, \code{delta}, \code{sd}, \code{alpha}, \code{beta}
\item For power: \code{mu}, \code{mu0}, \code{delta}, \code{sd}, \code{alpha}, \code{n}
}
}
}
\examples{
# Sample size for `"2-side"` test
one_mean_size(mu = 2, mu0 = 1.5, sd = 1,
              alpha = 0.05, beta = 0.2, test_type = "2-side")

# Power of `"2-side"` test
one_mean_size(mu = 2, mu0 = 1.5, sd = 1,
              alpha = 0.05, n = 32, test_type = "2-side")

# Sample size for `"1-side"` test
one_mean_size(mu = 115, mu0 = 120, sd = 24,
              alpha = 0.05, beta = 0.2, test_type = "1-side")

# Power of `"1-side"` test
one_mean_size(mu = 115, mu0 = 120, sd = 24,
              alpha = 0.05, n = 143, test_type = "1-side")

# Sample size for `"non-inferiority"` test
one_mean_size(mu = 2, mu0 = 1.5, delta = -0.5, sd = 1,
              alpha = 0.05, beta = 0.2, test_type = "non-inferiority")

# Power of `"non-inferiority"` test
one_mean_size(mu = 2, mu0 = 1.5, delta = -0.5, sd = 1,
              alpha = 0.05, n = 7, test_type = "non-inferiority")

# Sample size for `"equivalence"` test
one_mean_size(mu = 2, mu0 = 2, delta = 0.05, sd = 0.1,
              alpha = 0.05, beta = 0.2, test_type = "equivalence")

# Power of `"equivalence"` test
one_mean_size(mu = 2, mu0 = 2, delta = 0.05, sd = 0.1,
              alpha = 0.05, n = 35, test_type = "equivalence")

}
