% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/k_prop_size.R
\name{k_prop_size}
\alias{k_prop_size}
\title{Sample Size or Power Calculation for K proportion}
\usage{
k_prop_size(pA, pB, tau, alpha, beta = NULL, n = NULL)
}
\arguments{
\item{pA}{Numeric. True proportion of group A.}

\item{pB}{Numeric. True proportion of group B.}

\item{tau}{Integer. Number of comparisons.}

\item{alpha}{Numeric. Type I error rate.}

\item{beta}{Numeric (optional). Type II error rate. Required for sample size calculation.}

\item{n}{Integer (optional). Sample size. Required when calculating power.}
}
\value{
Returns sample size (if \code{beta} is given), or power (if \code{n} is given).
}
\description{
Calculates sample size or power for a multiple-sample proportion test.
}
\note{
Only one of \code{beta} (for sample size calculation) or \code{n} (for power calculation) should be specified.

Required arguments:
\itemize{
\item For sample size: \code{pA}, \code{pB}, \code{tau}, \code{alpha}, \code{beta}
\item For power: \code{pA}, \code{pB}, \code{tau}, \code{alpha}, \code{n}
}
}
\examples{
# Sample size
k_prop_size(pA = 0.2, pB = 0.4, tau = 2,
            alpha = 0.05, beta = 0.2)

# Power
k_prop_size(pA = 0.2, pB = 0.4, tau = 2,
            alpha = 0.05, n = 96)

}
