% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xgb.R
\name{xgb_model}
\alias{xgb_model}
\title{Train a Gradient Boosting Model using XGBoost}
\usage{
xgb_model(train_vectorized, Y, test_vectorized, parallel = FALSE, tune = FALSE)
}
\arguments{
\item{train_vectorized}{The training feature matrix (e.g., a `dfm` from quanteda).}

\item{Y}{The response variable for the training set. Should be a factor.}

\item{test_vectorized}{The test feature matrix, which must have the same
features as `train_vectorized`.}

\item{parallel}{Logical}

\item{tune}{Logical}
}
\value{
A list containing four elements:
  \item{pred}{A vector of class predictions for the test set.}
  \item{probs}{A matrix of predicted probabilities.}
  \item{model}{The final, trained `xgb.Booster` model object.}
  \item{best_lambda}{Placeholder (NULL) for pipeline consistency.}
}
\description{
This function trains a model using the xgboost package. It is highly
efficient and natively supports sparse matrices, making it ideal for text data.
It automatically handles both binary and multi-class classification problems.
}
\examples{
\dontrun{
# Create dummy vectorized training and test data
train_matrix <- matrix(runif(100), nrow = 10, ncol = 10)
test_matrix <- matrix(runif(50), nrow = 5, ncol = 10)

# Provide column names (vocabulary) required by xgboost
colnames(train_matrix) <- paste0("word", 1:10)
colnames(test_matrix) <- paste0("word", 1:10)

y_train <- factor(sample(c("P", "N"), 10, replace = TRUE))

# Run xgboost model
model_results <- xgb_model(train_matrix, y_train, test_matrix)
}
}
