% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theme.R
\name{theme_colors_flextable}
\alias{theme_colors_flextable}
\alias{theme_brand_flextable}
\alias{theme_colors_ggplot2}
\alias{theme_brand_ggplot2}
\alias{theme_colors_gt}
\alias{theme_brand_gt}
\alias{theme_colors_plotly}
\alias{theme_brand_plotly}
\alias{theme_colors_thematic}
\alias{theme_brand_thematic}
\title{Create a theme for a plotting or table package}
\usage{
theme_colors_flextable(bg, fg)

theme_brand_flextable(brand_yml)

theme_colors_ggplot2(bg, fg)

theme_brand_ggplot2(brand_yml)

theme_colors_gt(bg, fg)

theme_brand_gt(brand_yml)

theme_colors_plotly(bg, fg)

theme_brand_plotly(brand_yml)

theme_colors_thematic(bg, fg)

theme_brand_thematic(brand_yml)
}
\arguments{
\item{bg}{The background color}

\item{fg}{The foreground color}

\item{brand_yml}{The path to a brand.yml file}
}
\description{
Create a theme using background and foreground colors (\verb{theme_colors_*}) or
using a \strong{brand.yml} file (\verb{theme_brand_*}).
}
\details{
The use of the theme will depend on the package. Please see
\href{https://examples.quarto.pub/lightdark-renderings-examples/ggplot2.html}{light/dark renderings examples}
for examples using each supported package with dark mode, \verb{theme_brand_*},
and \verb{renderings: [light, dark]},
or \href{https://quarto-dev.github.io/quarto-r/articles/theme-helpers.html}{theme helper article}
for examples using each package and \verb{theme_colors_*} to specify the
background and foreground colors directly.
}
