% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/texts.R
\name{texts}
\alias{texts}
\alias{texts<-}
\title{Get or assign corpus texts [deprecated]}
\usage{
texts(x, groups = NULL, spacer = " ")

texts(x) <- value
}
\arguments{
\item{x}{a \link{corpus}}

\item{groups}{grouping variable for sampling, equal in length to the number
of documents. This will be evaluated in the docvars data.frame, so that
docvars may be referred to by name without quoting. This also changes
previous behaviours for \code{groups}. See \code{news(Version >= "3.0", package = "quanteda")} for details.}

\item{spacer}{when concatenating texts by using \code{groups}, this will be the
spacing added between texts.  (Default is two spaces.)}

\item{value}{character vector of the new texts}
}
\value{
For \code{texts}, a character vector of the texts in the corpus.

For \verb{texts <-}, the corpus with the updated texts.

for \verb{texts <-}, a corpus with the texts replaced by \code{value}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#superseded}{\figure{lifecycle-superseded.svg}{options: alt='[Superseded]'}}}{\strong{[Superseded]}}

This function has been made defunct and replaced.
\itemize{
\item Use \code{\link[=as.character.corpus]{as.character.corpus()}} to turn a corpus into a simple named character
vector.
\item Use \code{\link[=corpus_group]{corpus_group()}} instead of \code{texts(x, groups = ...)} to aggregate texts
by a grouping variable.
\item Use \code{\link{[<-}} instead of \verb{texts()<-} for replacing texts in a corpus object.
}
}
\details{
Get or replace the texts in a \link{corpus}, with grouping options.
Works for plain character vectors too, if \code{groups} is a factor.
}
\note{
The \code{groups} will be used for concatenating the texts based on shared
values of \code{groups}, without any specified order of aggregation.

You are strongly encouraged as a good practice of text analysis
workflow \emph{not} to modify the substance of the texts in a corpus.
Rather, this sort of processing is better performed through downstream
operations.  For instance, do not lowercase the texts in a corpus, or you
will never be able to recover the original case.  Rather, apply
\code{\link[=tokens_tolower]{tokens_tolower()}} after applying \code{\link[=tokens]{tokens()}} to a
corpus, or use the option \code{tolower = TRUE} in \code{\link[=dfm]{dfm()}}.
}
\keyword{corpus}
\keyword{internal}
