% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subset_viterbi.R
\name{subset.viterbi}
\alias{subset.viterbi}
\alias{[.viterbi}
\title{Subsetting Viterbi results}
\usage{
\method{subset}{viterbi}(x, ind = NULL, chr = NULL, ...)

\method{[}{viterbi}(x, ind = NULL, chr = NULL)
}
\arguments{
\item{x}{Imputed genotypes as output from \code{\link[=viterbi]{viterbi()}}.}

\item{ind}{A vector of individuals: numeric indices, logical
values, or character string IDs}

\item{chr}{A vector of chromosomes: logical values, or character
string IDs. Numbers are interpreted as character string IDs.}

\item{...}{Ignored.}
}
\value{
An object of class \code{"viterbi"}, like the input, with the
selected individuals and/or chromosomes; see \code{\link[=viterbi]{viterbi()}}.
}
\description{
Pull out a specified set of individuals and/or chromosomes from
the results of \code{\link[=viterbi]{viterbi()}}
}
\examples{
grav2 <- read_cross2(system.file("extdata", "grav2.zip", package="qtl2"))
\dontshow{grav2 <- grav2[1:8,c(1,2)]}
g <- viterbi(grav2)
# keep just individuals 1:5, chromosome 2
gsub <- g[1:5,2]
# keep just chromosome 2
gsub2 <- g[,2]
}
\keyword{utilities}
