% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drop_markers.R
\name{pull_markers}
\alias{pull_markers}
\title{Drop all but a specified set of markers}
\usage{
pull_markers(cross, markers)
}
\arguments{
\item{cross}{Object of class \code{"cross2"}. For details, see the
\href{https://kbroman.org/qtl2/assets/vignettes/developer_guide.html}{R/qtl2 developer guide}.}

\item{markers}{A vector of marker names.}
}
\value{
The input \code{cross} with only the specified markers.
}
\description{
Drop all markers from a cross2 object expect those in a specified vector.
}
\examples{
grav2 <- read_cross2(system.file("extdata", "grav2.zip", package="qtl2"))
markers2drop <- c("BH.342C/347L-Col", "GH.94L", "EG.357C/359L-Col", "CD.245L", "ANL2")
grav2_rev <- pull_markers(grav2, markers2drop)
}
\seealso{
\code{\link[=drop_markers]{drop_markers()}}, \code{\link[=drop_nullmarkers]{drop_nullmarkers()}}
}
