% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pull_genoprobint.R
\name{pull_genoprobint}
\alias{pull_genoprobint}
\title{Pull genotype probabilities for an interval}
\usage{
pull_genoprobint(genoprobs, map, chr, interval)
}
\arguments{
\item{genoprobs}{Genotype probabilities as calculated by
\code{\link[=calc_genoprob]{calc_genoprob()}}.}

\item{map}{The marker map for the genotype probabilities}

\item{chr}{Chromosome ID (single character sting)}

\item{interval}{Interval (pair of numbers)}
}
\value{
A list containing a single 3d array of genotype probabilities, like the input \code{genoprobs}
but for the designated interval.
}
\description{
Pull out the genotype probabilities for a given genomic interval
}
\examples{
iron <- read_cross2(system.file("extdata", "iron.zip", package="qtl2"))
\dontshow{iron <- iron[,"8"]}
gmap <- insert_pseudomarkers(iron$gmap, step=1)
pr <- calc_genoprob(iron, gmap, error_prob=0.002)

pr_sub <- pull_genoprobint(pr, gmap, "8", c(25, 35))

}
\seealso{
\code{\link[=find_marker]{find_marker()}}, \code{\link[=pull_genoprobpos]{pull_genoprobpos()}}
}
