% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_lodpeaks.R
\name{plot_lodpeaks}
\alias{plot_lodpeaks}
\title{Plot LOD scores vs QTL peak locations}
\usage{
plot_lodpeaks(peaks, map, chr = NULL, gap = NULL, intervals = FALSE, ...)
}
\arguments{
\item{peaks}{Data frame such as that produced by
\code{\link[=find_peaks]{find_peaks()}}) containing columns
\code{chr}, \code{pos}, \code{lodindex}, and \code{lodcolumn}.
May also contain columns \code{ci_lo} and \code{ci_hi}, in
which case intervals will be plotted.}

\item{map}{Marker map, used to get chromosome lengths (and start
and end positions).}

\item{chr}{Selected chromosomes to plot; a vector of character
strings.}

\item{gap}{Gap between chromosomes. The default is 1\% of the total genome length.}

\item{intervals}{If TRUE and \code{peaks} contains QTL intervals, plot the intervals.}

\item{...}{Additional graphics parameters}
}
\value{
None.
}
\description{
Create a scatterplot of LOD scores vs QTL peak locations (possibly with intervals) for multiple traits.
}
\section{Hidden graphics parameters}{

A number of graphics parameters can be passed via \code{...}. For
example, \code{bgcolor} to control the background color and
\code{altbgcolor} to control the background color on alternate chromosomes.
These are not included as formal parameters in order to avoid
cluttering the function definition.
}

\examples{
# read data
iron <- read_cross2(system.file("extdata", "iron.zip", package="qtl2"))
\dontshow{iron <- iron[,c(1,2,7,8,9,13,15,16,19)]}

# insert pseudomarkers into map
map <- insert_pseudomarkers(iron$gmap, step=1)

# calculate genotype probabilities
probs <- calc_genoprob(iron, map, error_prob=0.002)

# grab phenotypes and covariates; ensure that covariates have names attribute
pheno <- iron$pheno
covar <- match(iron$covar$sex, c("f", "m")) # make numeric
names(covar) <- rownames(iron$covar)
Xcovar <- get_x_covar(iron)

# perform genome scan
out <- scan1(probs, pheno, addcovar=covar, Xcovar=Xcovar)

# find peaks above lod=3.5 (and calculate 1.5-LOD support intervals)
peaks <- find_peaks(out, map, threshold=3.5, drop=1.5)

plot_lodpeaks(peaks, map)
}
\seealso{
\code{\link[=find_peaks]{find_peaks()}}, \code{\link[=plot_peaks]{plot_peaks()}}
}
