% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/options.R
\name{qol_options}
\alias{qol_options}
\alias{set_print}
\alias{get_print}
\alias{set_monitor}
\alias{get_monitor}
\alias{set_na.rm}
\alias{get_na.rm}
\alias{set_output}
\alias{get_output}
\alias{set_titles}
\alias{get_titles}
\alias{set_footnotes}
\alias{get_footnotes}
\title{Set Global Print Option}
\usage{
set_print(...)

get_print()

set_monitor(...)

get_monitor()

set_na.rm(...)

get_na.rm()

set_output(...)

get_output()

set_titles(...)

get_titles()

set_footnotes(...)

get_footnotes()
}
\arguments{
\item{...}{Put in TRUE or FALSE to activate or deactivate the option.}
}
\value{
\code{\link[=set_print]{set_print()}}: Changed global print option.

\code{\link[=get_print]{get_print()}}: TRUE or FALSE.

\code{\link[=set_monitor]{set_monitor()}}: Changed global monitor option.

\code{\link[=get_monitor]{get_monitor()}}: TRUE or FALSE.

\code{\link[=set_na.rm]{set_na.rm()}}: Changed global na.rm option.

\code{\link[=get_na.rm]{get_na.rm()}}: TRUE or FALSE.

\code{\link[=set_output]{set_output()}}: Changed global output option.

\code{\link[=get_output]{get_output()}}: Current output option as character.

\code{\link[=set_titles]{set_titles()}}: Changed global titles.

\code{\link[=get_titles]{get_titles()}}: Current titles as character.

\code{\link[=set_footnotes]{set_footnotes()}}: Changed global footnotes.

\code{\link[=get_footnotes]{get_footnotes()}}: Current footnotes as character.
}
\description{
\code{\link[=set_print]{set_print()}}: Set the print option globally for the tabulation and export to
Excel functions.

\code{\link[=get_print]{get_print()}}: Get the globally stored print option.

\code{\link[=set_monitor]{set_monitor()}}: Set the monitor option globally for the heavier functions which are
able to show how they work internally.

\code{\link[=get_monitor]{get_monitor()}}: Get the globally stored monitor option.

\code{\link[=set_na.rm]{set_na.rm()}}: Set the na.rm option globally for each function which can remove
NA values.

\code{\link[=get_na.rm]{get_na.rm()}}: Get the globally stored na.rm option.

\code{\link[=set_output]{set_output()}}: Set the output option globally for each function that can output
results to "console", "text", "excel" or "excel_nostyle".

\code{\link[=get_output]{get_output()}}: Get the globally stored output option.

\code{\link[=set_titles]{set_titles()}}: Set the titles globally for each function that can print titles
above the output table.

\code{\link[=get_titles]{get_titles()}}: Get the globally stored titles.

\code{\link[=set_footnotes]{set_footnotes()}}: Set the footnotes globally for each function that can print footnotes
above the output table.

\code{\link[=get_footnotes]{get_footnotes()}}: Get the globally stored footnotes.
}
\examples{
set_print(FALSE)
set_print(TRUE)

get_print()

set_monitor(TRUE)
set_monitor(FALSE)

get_monitor()

set_na.rm(TRUE)
set_na.rm(FALSE)

get_na.rm()

set_output("excel")

get_output()

set_titles("This is title number 1 link: https://cran.r-project.org/",
           "This is title number 2",
           "This is title number 3")

get_titles()

set_footnotes("This is title number 1 link: https://cran.r-project.org/",
           "This is title number 2",
           "This is title number 3")

get_footnotes()

}
