# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Computation of the sum sum_c(w_c*psi_c) parallelized version
#'@param  Hconfig list of  vector of 0 and 1, corresponding to the configurations
#'@param  NewPrior a double vector containing the prior w_c
#'@param  Logf0Mat a double matrix containing the log(f0(xi_q)) 
#'@param  Logf1Mat a double matrix containing the log(f1(xi_q)) 
#'@param  threads_nb an int the number of threads
#'@return a double vector containing sum_c(w_c*psi_c)
#'
fHconfig_sum_update_ptr_parallel <- function(Hconfig, NewPrior, Logf0Mat, Logf1Mat, threads_nb = 0L) {
    .Call(`_qch_fHconfig_sum_update_ptr_parallel`, Hconfig, NewPrior, Logf0Mat, Logf1Mat, threads_nb)
}

#' Update of the prior estimate in EM algo parallelized version
#'@param  Hconfig list of  vector of 0 and 1, corresponding to the configurations
#'@param  fHconfig_sum a double vector containing sum_c(w_c*psi_c), obtained by fHconfig_sum_update_ptr_parallel()
#'@param  OldPrior a double vector containing the prior w_c 
#'@param  Logf0Mat a double matrix containing the log(f0(xi_q)) 
#'@param  Logf1Mat a double matrix containing the log(f1(xi_q)) 
#'@param  threads_nb an int the number of threads
#'@return a double vector containing the new estimate of prior w_c
#'
prior_update_arma_ptr_parallel <- function(Hconfig, fHconfig_sum, OldPrior, Logf0Mat, Logf1Mat, threads_nb = 0L) {
    .Call(`_qch_prior_update_arma_ptr_parallel`, Hconfig, fHconfig_sum, OldPrior, Logf0Mat, Logf1Mat, threads_nb)
}

#' Computation of the sum sum_c(w_c*psi_c) using Gaussian copula parallelized version
#'@param  Hconfig list of  vector of 0 and 1, corresponding to the configurations
#'@param  NewPrior a double vector containing the prior w_c
#'@param  Logf0Mat a double matrix containing the log(f0(xi_q)) 
#'@param  Logf1Mat a double matrix containing the log(f1(xi_q)) 
#'@param  zeta0 a double matrix containing the qnorm(F0(x_iq))
#'@param  zeta1 a double matrix containing the qnorm(F1(x_iq))
#'@param  R a double matrix corresponding to the copula parameter
#'@param  Rinv a double matrix corresponding to the inverse copula parameter
#'@param  threads_nb an int the number of threads
#'@return a double vector containing sum_c(w_c*psi_c)
#'
fHconfig_sum_update_gaussian_copula_ptr_parallel <- function(Hconfig, NewPrior, Logf0Mat, Logf1Mat, zeta0, zeta1, R, Rinv, threads_nb = 0L) {
    .Call(`_qch_fHconfig_sum_update_gaussian_copula_ptr_parallel`, Hconfig, NewPrior, Logf0Mat, Logf1Mat, zeta0, zeta1, R, Rinv, threads_nb)
}

#' Update of the prior estimate in EM algo using Gaussian copula, parallelized version
#'@param  Hconfig list of  vector of 0 and 1, corresponding to the configurations
#'@param  fHconfig_sum a double vector containing sum_c(w_c*psi_c), obtained by fHconfig_sum_update_ptr_parallel()
#'@param  OldPrior a double vector containing the prior w_c 
#'@param  Logf0Mat a double matrix containing the log(f0(xi_q)) 
#'@param  Logf1Mat a double matrix containing the log(f1(xi_q))
#'@param  zeta0 a double matrix containing the qnorm(F0(x_iq))
#'@param  zeta1 a double matrix containing the qnorm(F1(x_iq))
#'@param  R a double matrix corresponding to the copula parameter
#'@param  Rinv a double matrix corresponding to the inverse copula parameter 
#'@param  threads_nb an int the number of threads
#'@return a double vector containing the new estimate of prior w_c
#'
prior_update_gaussian_copula_ptr_parallel <- function(Hconfig, fHconfig_sum, OldPrior, Logf0Mat, Logf1Mat, zeta0, zeta1, R, Rinv, threads_nb = 0L) {
    .Call(`_qch_prior_update_gaussian_copula_ptr_parallel`, Hconfig, fHconfig_sum, OldPrior, Logf0Mat, Logf1Mat, zeta0, zeta1, R, Rinv, threads_nb)
}

#' Update the estimate of R correlation matrix of the gaussian copula, parallelized version 
#'@param  Hconfig list of vector of 0 and 1, corresponding to the configurations
#'@param  fHconfig_sum a double vector containing sum_c(w_c*psi_c), obtained by fHconfig_sum_update_ptr_parallel()
#'@param  OldPrior a double vector containing the prior w_c 
#'@param  Logf0Mat a double matrix containing the log(f0(xi_q)) 
#'@param  Logf1Mat a double matrix containing the log(f1(xi_q))
#'@param  zeta0 a double matrix containing the qnorm(F0(x_iq))
#'@param  zeta1 a double matrix containing the qnorm(F1(x_iq))
#'@param  OldR a double matrix corresponding to the copula parameter
#'@param  OldRinv a double matrix corresponding to the inverse copula parameter 
#'@param  RhoIndex a int matrix containing the index of lower triangular part of a matrix
#'@param  threads_nb an int the number of threads
#'@return a double vector containing the lower triangular part of the MLE of R
R_MLE_update_gaussian_copula_ptr_parallel <- function(Hconfig, fHconfig_sum, OldPrior, Logf0Mat, Logf1Mat, zeta0, zeta1, OldR, OldRinv, RhoIndex, threads_nb = 0L) {
    .Call(`_qch_R_MLE_update_gaussian_copula_ptr_parallel`, Hconfig, fHconfig_sum, OldPrior, Logf0Mat, Logf1Mat, zeta0, zeta1, OldR, OldRinv, RhoIndex, threads_nb)
}

