% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fn_npsdr_x.R
\name{npsdr_x}
\alias{npsdr_x}
\title{Reconstruct the estimated sufficient predictors for a given data matrix}
\usage{
npsdr_x(object, newdata, d = 2)
}
\arguments{
\item{object}{The object from function \code{npsdr}}

\item{newdata}{new data \eqn{\mathbf{X}}}

\item{d}{structural dimensionality. d=2 is default.}
}
\value{
the value of the estimated nonlinear mapping \eqn{\phi(\cdot)} is applied to
newdata \eqn{X} with dimension d is returned.
}
\description{
Returning the estimated sufficient predictors \eqn{\hat{\phi}(\mathbf{x})} for a given \eqn{\mathbf{x}}
}
\examples{
\donttest{
set.seed(1)
n <- 200; n.new <- 300
p <- 5;
h <- 20;
x <- matrix(rnorm(n*p, 0, 2), n, p)
y <- 0.5*sqrt((x[,1]^2+x[,2]^2))*(log(x[,1]^2+x[,2]^2))+ 0.2*rnorm(n)
new.x <- matrix(rnorm(n.new*p, 0, 2), n.new, p)
obj_kernel <- npsdr(x, y)
npsdr_x(object=obj_kernel, newdata=new.x)
}
}
\seealso{
\code{\link{npsdr}}
}
\author{
Jungmin Shin, \email{jungminshin@korea.ac.kr}, Seung Jun Shin, \email{sjshin@korea.ac.kr}, Andreas Artemiou \email{artemiou@uol.ac.cy}
}
