% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psrwe_outana.R
\name{psrwe_outana}
\alias{psrwe_outana}
\title{Outcome Analysis for PS-Integrated Estimation}
\usage{
psrwe_outana(
  dta_psrst,
  method_ci = c("wald", "wilson"),
  conf_type = c("log_log", "plain"),
  conf_int = 0.95,
  alternative = c("less", "greater", "two_sided"),
  mu = 0,
  method_pval = c("wald", "score", "score_weighted"),
  ...
)
}
\arguments{
\item{dta_psrst}{A returned object with class \code{PSRWE_EST}}

\item{method_ci}{A method name for confidence interval (default wald)}

\item{conf_type}{A type name of transformation for the confidence interval
of PSKM approach (default log_log)}

\item{conf_int}{A two-sided level of confidence/credible limits
(default 0.95)}

\item{alternative}{A character string for the alternative hypothesis that
must be one of \code{"less"} (default) or \code{"greater"}, or
\code{"two_sided"} (for log-rank and RMST only)}

\item{mu}{A number indicating the true value of the parameter of interest
(or the difference in means for two arms),
\code{mu = 0} when the test is log-rank or RMST}

\item{method_pval}{A method name for p-value (default wald),
no impact for Bayesian method, and
\code{method = "score"} only is for binary outcome in
single arm study (i.e., comparing with a PG set by \code{mu})}

\item{...}{Other options}
}
\value{
A list with class name \code{PSRWE_EST_OUTANA}.
}
\description{
Report outcome analysis for the PS-integrated approach.
}
\details{
This function is mainly for summarizing and reporting the
    outcome analysis for the PS-integrated estimation.
    The input \code{dta_psrst} can be generated from the functions
    \code{\link{psrwe_powerp}}, \code{\link{psrwe_compl}}, and
    \code{\link{psrwe_survkm}}.
    See the functions \code{\link{psrwe_ci}} and \code{\link{psrwe_infer}}
    for the options of outcome analyses.
}
\examples{
data(ex_dta)
dta_ps <- psrwe_est(ex_dta,
       v_covs = paste("V", 1:7, sep = ""),
       v_grp = "Group",
       cur_grp_level = "current")
ps_borrow <- psrwe_borrow(total_borrow = 30, dta_ps)
ps_rst <- psrwe_compl(ps_borrow, v_outcome = "Y_Con")
rst <- psrwe_outana(ps_rst)
rst

}
