% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marxan.R
\name{marxan_alphas}
\alias{marxan_alphas}
\title{Marxan: Alpha irreplaceabilities}
\usage{
marxan_alphas(input, triage = FALSE)
}
\arguments{
\item{input}{string - The address of the input.dat file.}

\item{triage}{logical - Should features with unachievable targets be given an
irreplaceability of 0? See \code{\link{alpha}}.}
}
\value{
A data.frame
}
\description{
Given a valid Marxan input.dat file, it returns a copy of the PUVSPRNAME file
(puvspr.dat), with additional columns containing the feature's global value,
target value, and alpha irreplaceability.
}
\details{
The global value is obtained as the sum of the feature's "amount" column in
PUVSPRNAME.

The target value is obtained from the SPECNAME file (spec.dat), either as the
proportion of the global value (if the "prop" column is present in
SPECNAME), or as the "target" value in SPECNAME (otherwise). This behaviour
mirrors Marxan's default behaviour.
}
\examples{
\dontrun{
marxan_alphas('/data/marxan/analysis01/input.dat')
marxan_alphas('C:\data\marxan\analysis01\input.dat')
}
}
\author{
Daniele Baisero, \email{daniele.baisero@gmail.com}
}
