% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_pomdp_solve.R
\name{find_pomdp_solve}
\alias{find_pomdp_solve}
\alias{pomdp-solve}
\alias{pomdpsolve}
\title{Find the executable for 'pomdp-solve'}
\usage{
find_pomdp_solve()
}
\value{
returns the path to the 'pomdp-solve' executable as a string or stops with an error.
}
\description{
Find the \code{pomdp-solve} executable
to solve Partially Observable Decision Processes (POMDPs) (Kaelbling et al, 1998)
installed by the \pkg{pomdpSolve} package.
}
\details{
This package only provides a direct interface to the executable.
A more convenient and powerful interface is provided by the function
\code{\link[pomdp:solve_POMDP]{pomdp::solve_POMDP()}} in package \pkg{pomdp}.

The executable of \code{pomdp-solve} in this direct interface needs to be called with
\code{\link[=system2]{system2()}} and runs in a separate process. This way, a failure in the solver will not compromise the
R session. \code{pomdp-solve} creates files with the value function and
the policy graph (see \link{read_write}).
}
\examples{
# find the location of the pomdp-solve executable
find_pomdp_solve()

# get pomdp-solve options
system2(find_pomdp_solve(), args = "-h")

# an example of how to solve a simple POMDP can be found in the man page
# for read_write.
}
\references{
Kaelbling, L.P., Littman, M.L., Cassandra, A.R. (1998).
Planning and acting in partially observable stochastic domains.
\emph{Artificial Intelligence.} \strong{101} (1–2): 99-134.
\doi{10.1016/S0004-3702(98)00023-X}

Anthony R. Cassandra, pomdp-solve documentation,
\url{https://www.pomdp.org/code/}

Anthony R. Cassandra, pomdp-solve source code GitHub repository,
\url{https://github.com/cassandra/pomdp-solve}
}
\seealso{
read_write
}
