% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pk_curve.R
\name{pk_curve}
\alias{pk_curve}
\title{Provide concentration-time curves.}
\usage{
pk_curve(
  t,
  model = "1cmt_oral",
  params = list(ka = 2.77, CL = 2.5, V = 25),
  dose = 600,
  ii = 24,
  addl = 0,
  ss = F
)
}
\arguments{
\item{t}{Observation time in h, specified as a vector.}

\item{model}{The model to use. Must be one of "1cmt_bolus", "1cmt_infusion", "1cmt_oral", "2cmt_bolus", "2cmt_infusion",
"2cmt_oral", "3cmt_bolus", "3cmt_infusion", "3cmt_oral". The default is "1cmt_oral".}

\item{params}{A named list containing parameter values for the selected model type.}

\item{dose}{Dose amount.}

\item{ii}{Interdose interval (or tau), in hours (default 24).}

\item{addl}{Number of additional doses (default 0).}

\item{ss}{Assume steady state concentration (default \code{FALSE}).}
}
\value{
A data frame containing times (\code{t}) and concentrations (\code{cp}).
}
\description{
Provide concentration-time curves.
}
\examples{
plot(pk_curve(t=seq(0,72,by=0.1), model="3cmt_oral", ii=12, addl=5,
  params=list(CL=2.5, V1=25, V2=2, V3=5, Q2=0.5, Q3=0.25, ka=1)), type="l")
}
\author{
Justin Wilkins, \email{justin.wilkins@occams.com}
}
